/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl.v1;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.pinot.$internal.org.apache.pinot.core.io.compression.ChunkCompressor;
import org.apache.pinot.$internal.org.apache.pinot.core.io.compression.ChunkCompressorFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.io.writer.SingleColumnSingleValueWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseChunkSingleValueWriter
implements SingleColumnSingleValueWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseChunkSingleValueWriter.class);
    protected final FileChannel _dataFile;
    protected ByteBuffer _header;
    protected final ByteBuffer _chunkBuffer;
    protected final ByteBuffer _compressedBuffer;
    protected final ChunkCompressor _chunkCompressor;
    protected int _chunkSize;
    protected int _dataOffset;

    protected BaseChunkSingleValueWriter(File file, ChunkCompressorFactory.CompressionType compressionType, int totalDocs, int numDocsPerChunk, int chunkSize, int sizeOfEntry, int version) throws FileNotFoundException {
        this._chunkSize = chunkSize;
        this._chunkCompressor = ChunkCompressorFactory.getCompressor(compressionType);
        this._dataOffset = this.writeHeader(compressionType, totalDocs, numDocsPerChunk, sizeOfEntry, version);
        this._chunkBuffer = ByteBuffer.allocateDirect(chunkSize);
        this._compressedBuffer = ByteBuffer.allocateDirect(chunkSize * 2);
        this._dataFile = new RandomAccessFile(file, "rw").getChannel();
    }

    @Override
    public void setChar(int row, char ch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInt(int row, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setShort(int row, short s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLong(int row, long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFloat(int row, float f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(int row, double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setString(int row, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBytes(int row, byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this._chunkBuffer.position() > 0) {
            this.writeChunk();
        }
        this._header.flip();
        this._dataFile.write(this._header, 0L);
        this._dataFile.close();
    }

    private int writeHeader(ChunkCompressorFactory.CompressionType compressionType, int totalDocs, int numDocsPerChunk, int sizeOfEntry, int version) {
        int numChunks = (totalDocs + numDocsPerChunk - 1) / numDocsPerChunk;
        int headerSize = (numChunks + 7) * 4;
        this._header = ByteBuffer.allocateDirect(headerSize);
        int offset = 0;
        this._header.putInt(version);
        offset += 4;
        this._header.putInt(numChunks);
        offset += 4;
        this._header.putInt(numDocsPerChunk);
        offset += 4;
        this._header.putInt(sizeOfEntry);
        offset += 4;
        if (version > 1) {
            this._header.putInt(totalDocs);
            offset += 4;
            this._header.putInt(compressionType.getValue());
            int dataHeaderStart = (offset += 4) + 4;
            this._header.putInt(dataHeaderStart);
        }
        return headerSize;
    }

    protected void writeChunk() {
        int sizeToWrite;
        this._chunkBuffer.flip();
        try {
            sizeToWrite = this._chunkCompressor.compress(this._chunkBuffer, this._compressedBuffer);
            this._dataFile.write(this._compressedBuffer, this._dataOffset);
            this._compressedBuffer.clear();
        }
        catch (IOException e) {
            LOGGER.error("Exception caught while compressing/writing data chunk", (Throwable)e);
            throw new RuntimeException(e);
        }
        this._header.putInt(this._dataOffset);
        this._dataOffset += sizeToWrite;
        this._chunkBuffer.clear();
    }
}

