/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl.v1;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.pinot.$internal.org.apache.pinot.core.io.util.FixedBitIntReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.io.writer.SingleColumnSingleValueWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class FixedBitSingleValueWriter
implements SingleColumnSingleValueWriter {
    private FixedBitIntReaderWriter dataFileWriter;

    public FixedBitSingleValueWriter(File file, int rows, int columnSizeInBits) throws Exception {
        long length = ((long)rows * (long)columnSizeInBits + 8L - 1L) / 8L;
        PinotDataBuffer dataBuffer = PinotDataBuffer.mapFile(file, false, 0L, length, ByteOrder.BIG_ENDIAN, this.getClass().getSimpleName());
        this.dataFileWriter = new FixedBitIntReaderWriter(dataBuffer, rows, columnSizeInBits);
    }

    @Override
    public void close() throws IOException {
        this.dataFileWriter.close();
    }

    @Override
    public void setChar(int row, char ch) {
        throw new UnsupportedOperationException("Only int data type is supported in fixedbit format");
    }

    @Override
    public void setInt(int row, int i) {
        this.dataFileWriter.writeInt(row, i);
    }

    @Override
    public void setShort(int row, short s) {
        throw new UnsupportedOperationException("Only int data type is supported in fixedbit format");
    }

    @Override
    public void setLong(int row, long l) {
        throw new UnsupportedOperationException("Only int data type is supported in fixedbit format");
    }

    @Override
    public void setFloat(int row, float f) {
        throw new UnsupportedOperationException("Only int data type is supported in fixedbit format");
    }

    @Override
    public void setDouble(int row, double d) {
        throw new UnsupportedOperationException("Only int data type is supported in fixedbit format");
    }

    @Override
    public void setString(int row, String string) {
        throw new UnsupportedOperationException("Only int data type is supported in fixedbit format");
    }

    @Override
    public void setBytes(int row, byte[] bytes) {
        throw new UnsupportedOperationException("Only int data type is supported in fixedbit format");
    }
}

