/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl.v1;

import java.io.File;
import java.io.FileNotFoundException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pinot.$internal.org.apache.pinot.core.io.compression.ChunkCompressorFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl.v1.BaseChunkSingleValueWriter;

@NotThreadSafe
public class FixedByteChunkSingleValueWriter
extends BaseChunkSingleValueWriter {
    private static final int CURRENT_VERSION = 2;
    private int _chunkDataOffset = 0;

    public FixedByteChunkSingleValueWriter(File file, ChunkCompressorFactory.CompressionType compressionType, int totalDocs, int numDocsPerChunk, int sizeOfEntry) throws FileNotFoundException {
        super(file, compressionType, totalDocs, numDocsPerChunk, sizeOfEntry * numDocsPerChunk, sizeOfEntry, 2);
    }

    @Override
    public void setInt(int row, int value) {
        this._chunkBuffer.putInt(value);
        this._chunkDataOffset += 4;
        this.flushChunkIfNeeded();
    }

    @Override
    public void setFloat(int row, float value) {
        this._chunkBuffer.putFloat(value);
        this._chunkDataOffset += 4;
        this.flushChunkIfNeeded();
    }

    @Override
    public void setLong(int row, long value) {
        this._chunkBuffer.putLong(value);
        this._chunkDataOffset += 8;
        this.flushChunkIfNeeded();
    }

    @Override
    public void setDouble(int row, double value) {
        this._chunkBuffer.putDouble(value);
        this._chunkDataOffset += 8;
        this.flushChunkIfNeeded();
    }

    @Override
    public void setBytes(int row, byte[] bytes) {
        this._chunkBuffer.put(bytes);
        this._chunkDataOffset += bytes.length;
        this.flushChunkIfNeeded();
    }

    @Override
    protected void writeChunk() {
        super.writeChunk();
        this._chunkDataOffset = 0;
    }

    private void flushChunkIfNeeded() {
        if (this._chunkDataOffset == this._chunkSize) {
            this.writeChunk();
        }
    }
}

