/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl.v1;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pinot.$internal.org.apache.pinot.core.io.compression.ChunkCompressorFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl.v1.BaseChunkSingleValueWriter;
import org.apache.pinot.common.utils.StringUtil;

@NotThreadSafe
public class VarByteChunkSingleValueWriter
extends BaseChunkSingleValueWriter {
    private static final int CURRENT_VERSION = 2;
    private final int _chunkHeaderSize;
    private int _chunkHeaderOffset = 0;
    private int _chunkDataOffSet;

    public VarByteChunkSingleValueWriter(File file, ChunkCompressorFactory.CompressionType compressionType, int totalDocs, int numDocsPerChunk, int lengthOfLongestEntry) throws FileNotFoundException {
        super(file, compressionType, totalDocs, numDocsPerChunk, numDocsPerChunk * 4 + lengthOfLongestEntry * numDocsPerChunk, lengthOfLongestEntry, 2);
        this._chunkDataOffSet = this._chunkHeaderSize = numDocsPerChunk * 4;
    }

    @Override
    public void setString(int row, String string) {
        byte[] bytes = StringUtil.encodeUtf8(string);
        this.setBytes(row, bytes);
    }

    @Override
    public void setBytes(int row, byte[] bytes) {
        this._chunkBuffer.putInt(this._chunkHeaderOffset, this._chunkDataOffSet);
        this._chunkHeaderOffset += 4;
        this._chunkBuffer.position(this._chunkDataOffSet);
        this._chunkBuffer.put(bytes);
        this._chunkDataOffSet += bytes.length;
        if (this._chunkHeaderOffset == this._chunkHeaderSize) {
            this.writeChunk();
        }
    }

    @Override
    public void close() throws IOException {
        if (this._chunkBuffer.position() > 0) {
            this.writeChunk();
        }
        this._header.flip();
        this._dataFile.write(this._header, 0L);
        this._dataFile.close();
    }

    @Override
    protected void writeChunk() {
        for (int i = this._chunkHeaderOffset; i < this._chunkHeaderSize; i += 4) {
            this._chunkBuffer.putInt(i, 0);
        }
        super.writeChunk();
        this._chunkHeaderOffset = 0;
        this._chunkDataOffSet = this._chunkHeaderSize;
    }
}

