/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.metadata;

import org.apache.pinot.$internal.org.apache.pinot.core.metadata.DefaultMetadataExtractor;
import org.apache.pinot.$internal.org.apache.pinot.core.metadata.MetadataExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataExtractorFactory {
    public static final Logger LOGGER = LoggerFactory.getLogger(MetadataExtractorFactory.class);

    private MetadataExtractorFactory() {
    }

    public static MetadataExtractor create(String metadataClassName) {
        String metadataExtractorClassName = metadataClassName;
        try {
            LOGGER.info("Instantiating MetadataExtractor class {}", (Object)metadataExtractorClassName);
            MetadataExtractor metadataExtractor = (MetadataExtractor)Class.forName(metadataExtractorClassName).newInstance();
            return metadataExtractor;
        }
        catch (Exception e) {
            LOGGER.warn("No metadata extractor class passed in, using default");
            return new DefaultMetadataExtractor();
        }
    }
}

