/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.minion;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.PinotSegmentRecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentGeneratorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.minion.segment.DefaultRecordPartitioner;
import org.apache.pinot.$internal.org.apache.pinot.core.minion.segment.MapperRecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.minion.segment.RecordPartitioner;
import org.apache.pinot.$internal.org.apache.pinot.core.minion.segment.ReducerRecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.common.config.IndexingConfig;
import org.apache.pinot.common.data.StarTreeIndexSpec;

public class SegmentConverter {
    private static final int DEFAULT_NUM_PARTITION = 1;
    private static final String MAPPER_PREFIX = "mapper_";
    private static final String REDUCER_PREFIX = "reducer_";
    private static final String INDEX_PREFIX = "index_";
    private List<File> _inputIndexDirs;
    private File _workingDir;
    private String _tableName;
    private String _segmentName;
    private .RecordTransformer _recordTransformer;
    private int _totalNumPartition;
    private RecordPartitioner _recordPartitioner;
    private .RecordAggregator _recordAggregator;
    private List<String> _groupByColumns;
    private IndexingConfig _indexingConfig;

    public SegmentConverter(@Nonnull List<File> inputIndexDirs, @Nonnull File workingDir, @Nonnull String tableName, @Nonnull String segmentName, int totalNumPartition, @Nonnull .RecordTransformer recordTransformer, @Nullable RecordPartitioner recordPartitioner, @Nullable .RecordAggregator recordAggregator, @Nullable List<String> groupByColumns, @Nullable IndexingConfig indexingConfig) {
        this._inputIndexDirs = inputIndexDirs;
        this._workingDir = workingDir;
        this._recordTransformer = recordTransformer;
        this._tableName = tableName;
        this._segmentName = segmentName;
        this._recordPartitioner = recordPartitioner == null ? new DefaultRecordPartitioner() : recordPartitioner;
        this._totalNumPartition = totalNumPartition < 1 ? 1 : totalNumPartition;
        this._recordAggregator = recordAggregator;
        this._groupByColumns = groupByColumns;
        this._indexingConfig = indexingConfig;
    }

    public List<File> convertSegment() throws Exception {
        ArrayList<File> resultFiles = new ArrayList<File>();
        for (int currentPartition = 0; currentPartition < this._totalNumPartition; ++currentPartition) {
            Preconditions.checkNotNull(this._recordTransformer);
            String mapperOutputPath = this._workingDir.getPath() + File.separator + MAPPER_PREFIX + currentPartition;
            String outputSegmentName = this._totalNumPartition <= 1 ? this._segmentName : this._segmentName + "_" + currentPartition;
            try (MapperRecordReader mapperRecordReader = new MapperRecordReader(this._inputIndexDirs, this._recordTransformer, this._recordPartitioner, this._totalNumPartition, currentPartition);){
                this.buildSegment(mapperOutputPath, this._tableName, outputSegmentName, mapperRecordReader, null);
            }
            File outputSegment = new File(mapperOutputPath + File.separator + outputSegmentName);
            if (this._recordAggregator != null && this._groupByColumns != null && this._groupByColumns.size() > 0) {
                String reducerOutputPath = this._workingDir.getPath() + File.separator + REDUCER_PREFIX + currentPartition;
                try (ReducerRecordReader reducerRecordReader = new ReducerRecordReader(outputSegment, this._recordAggregator, this._groupByColumns);){
                    this.buildSegment(reducerOutputPath, this._tableName, outputSegmentName, reducerRecordReader, null);
                }
                outputSegment = new File(reducerOutputPath + File.separator + outputSegmentName);
            }
            if (this._indexingConfig != null) {
                List<String> sortedColumn = this._indexingConfig.getSortedColumn();
                StarTreeIndexSpec starTreeIndexSpec = this._indexingConfig.getStarTreeIndexSpec();
                List<String> invertedIndexColumns = this._indexingConfig.getInvertedIndexColumns();
                if (sortedColumn != null && !sortedColumn.isEmpty() || starTreeIndexSpec != null || invertedIndexColumns != null) {
                    String indexGenerationOutputPath = this._workingDir.getPath() + File.separator + INDEX_PREFIX + currentPartition;
                    try (PinotSegmentRecordReader recordReader = new PinotSegmentRecordReader(outputSegment, null, sortedColumn);){
                        this.buildSegment(indexGenerationOutputPath, this._tableName, outputSegmentName, recordReader, this._indexingConfig);
                    }
                    outputSegment = new File(indexGenerationOutputPath + File.separator + outputSegmentName);
                }
            }
            resultFiles.add(outputSegment);
        }
        return resultFiles;
    }

    private void buildSegment(String outputPath, String tableName, String segmentName, RecordReader recordReader, IndexingConfig indexingConfig) throws Exception {
        SegmentGeneratorConfig segmentGeneratorConfig = new SegmentGeneratorConfig(recordReader.getSchema());
        segmentGeneratorConfig.setOutDir(outputPath);
        segmentGeneratorConfig.setTableName(tableName);
        segmentGeneratorConfig.setSegmentName(segmentName);
        if (indexingConfig != null) {
            segmentGeneratorConfig.setInvertedIndexCreationColumns(indexingConfig.getInvertedIndexColumns());
            if (indexingConfig.getStarTreeIndexSpec() != null) {
                segmentGeneratorConfig.enableStarTreeIndex(indexingConfig.getStarTreeIndexSpec());
            }
        }
        SegmentIndexCreationDriverImpl driver = new SegmentIndexCreationDriverImpl();
        driver.init(segmentGeneratorConfig, recordReader);
        driver.build();
    }

    public static class Builder {
        private List<File> _inputIndexDirs;
        private File _workingDir;
        private String _tableName;
        private String _segmentName;
        private .RecordTransformer _recordTransformer;
        private int _totalNumPartition;
        private RecordPartitioner _recordPartitioner;
        private .RecordAggregator _recordAggregator;
        private List<String> _groupByColumns;
        private IndexingConfig _indexingConfig;

        public Builder setInputIndexDirs(List<File> inputIndexDirs) {
            this._inputIndexDirs = inputIndexDirs;
            return this;
        }

        public Builder setWorkingDir(File workingDir) {
            this._workingDir = workingDir;
            return this;
        }

        public Builder setTableName(String tableName) {
            this._tableName = tableName;
            return this;
        }

        public Builder setSegmentName(String segmentName) {
            this._segmentName = segmentName;
            return this;
        }

        public Builder setRecordTransformer(.RecordTransformer recordTransformer) {
            this._recordTransformer = recordTransformer;
            return this;
        }

        public Builder setRecordPartitioner(RecordPartitioner recordPartitioner) {
            this._recordPartitioner = recordPartitioner;
            return this;
        }

        public Builder setRecordAggregator(.RecordAggregator recordAggregator) {
            this._recordAggregator = recordAggregator;
            return this;
        }

        public Builder setTotalNumPartition(int totalNumPartition) {
            this._totalNumPartition = totalNumPartition;
            return this;
        }

        public Builder setGroupByColumns(List<String> groupByColumns) {
            this._groupByColumns = groupByColumns;
            return this;
        }

        public Builder setIndexingConfig(IndexingConfig indexingConfig) {
            this._indexingConfig = indexingConfig;
            return this;
        }

        public SegmentConverter build() {
            if (this._groupByColumns != null && this._groupByColumns.size() > 0) {
                Preconditions.checkNotNull(this._groupByColumns, "If group-by columns are given, the record aggregator is required.");
            } else {
                Preconditions.checkArgument(this._recordAggregator == null, "If group-by columns are not given, the record aggregator has to be null.");
            }
            return new SegmentConverter(this._inputIndexDirs, this._workingDir, this._tableName, this._segmentName, this._totalNumPartition, this._recordTransformer, this._recordPartitioner, this._recordAggregator, this._groupByColumns, this._indexingConfig);
        }
    }
}

