/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator;

public class ExecutionStatistics {
    private long _numDocsScanned;
    private long _numEntriesScannedInFilter;
    private long _numEntriesScannedPostFilter;
    private long _numTotalRawDocs;
    private long _numSegmentsProcessed;
    private long _numSegmentsMatched;

    public ExecutionStatistics() {
    }

    public ExecutionStatistics(long numDocsScanned, long numEntriesScannedInFilter, long numEntriesScannedPostFilter, long numTotalRawDocs) {
        this._numDocsScanned = numDocsScanned;
        this._numEntriesScannedInFilter = numEntriesScannedInFilter;
        this._numEntriesScannedPostFilter = numEntriesScannedPostFilter;
        this._numTotalRawDocs = numTotalRawDocs;
        this._numSegmentsProcessed = 1L;
        this._numSegmentsMatched = numDocsScanned == 0L ? 0L : 1L;
    }

    public long getNumDocsScanned() {
        return this._numDocsScanned;
    }

    public long getNumEntriesScannedInFilter() {
        return this._numEntriesScannedInFilter;
    }

    public long getNumEntriesScannedPostFilter() {
        return this._numEntriesScannedPostFilter;
    }

    public long getNumTotalRawDocs() {
        return this._numTotalRawDocs;
    }

    public long getNumSegmentsProcessed() {
        return this._numSegmentsProcessed;
    }

    public long getNumSegmentsMatched() {
        return this._numSegmentsMatched;
    }

    public void merge(ExecutionStatistics executionStatisticsToMerge) {
        this._numDocsScanned += executionStatisticsToMerge._numDocsScanned;
        this._numEntriesScannedInFilter += executionStatisticsToMerge._numEntriesScannedInFilter;
        this._numEntriesScannedPostFilter += executionStatisticsToMerge._numEntriesScannedPostFilter;
        this._numTotalRawDocs += executionStatisticsToMerge._numTotalRawDocs;
        this._numSegmentsProcessed += executionStatisticsToMerge._numSegmentsProcessed;
        this._numSegmentsMatched += executionStatisticsToMerge._numSegmentsMatched;
    }

    public String toString() {
        return "Execution Statistics:\n  numDocsScanned: " + this._numDocsScanned + "\n  numEntriesScannedInFilter: " + this._numEntriesScannedInFilter + "\n  numEntriesScannedPostFilter: " + this._numEntriesScannedPostFilter + "\n  numTotalRawDocs: " + this._numTotalRawDocs + "\n  numSegmentsProcessed: " + this._numSegmentsProcessed + "\n  numSegmentsMatched: " + this._numSegmentsMatched;
    }
}

