/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Block;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.$internal.org.apache.pinot.core.common.datatable.DataTableImplV2;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;

public class IntermediateResultsBlock
implements Block {
    private DataSchema _selectionDataSchema;
    private Collection<Serializable[]> _selectionResult;
    private AggregationFunctionContext[] _aggregationFunctionContexts;
    private List<Object> _aggregationResult;
    private AggregationGroupByResult _aggregationGroupByResult;
    private List<Map<String, Object>> _combinedAggregationGroupByResult;
    private List<ProcessingException> _processingExceptions;
    private long _numDocsScanned;
    private long _numEntriesScannedInFilter;
    private long _numEntriesScannedPostFilter;
    private long _numTotalRawDocs;
    private long _numSegmentsProcessed;
    private long _numSegmentsMatched;
    private boolean _numGroupsLimitReached;

    public IntermediateResultsBlock(@Nonnull DataSchema selectionDataSchema, @Nonnull Collection<Serializable[]> selectionResult) {
        this._selectionDataSchema = selectionDataSchema;
        this._selectionResult = selectionResult;
    }

    public IntermediateResultsBlock(@Nonnull AggregationFunctionContext[] aggregationFunctionContexts, @Nonnull List aggregationResult, boolean isGroupBy) {
        this._aggregationFunctionContexts = aggregationFunctionContexts;
        if (isGroupBy) {
            this._combinedAggregationGroupByResult = aggregationResult;
        } else {
            this._aggregationResult = aggregationResult;
        }
    }

    public IntermediateResultsBlock(@Nonnull AggregationFunctionContext[] aggregationFunctionContexts, @Nullable AggregationGroupByResult aggregationGroupByResults) {
        this._aggregationFunctionContexts = aggregationFunctionContexts;
        this._aggregationGroupByResult = aggregationGroupByResults;
    }

    public IntermediateResultsBlock(@Nonnull ProcessingException processingException, @Nonnull Exception e) {
        this._processingExceptions = new ArrayList<ProcessingException>();
        this._processingExceptions.add(QueryException.getException(processingException, e));
    }

    public IntermediateResultsBlock(@Nonnull Exception e) {
        this(QueryException.QUERY_EXECUTION_ERROR, e);
    }

    @Nullable
    public DataSchema getSelectionDataSchema() {
        return this._selectionDataSchema;
    }

    public void setSelectionDataSchema(@Nullable DataSchema dataSchema) {
        this._selectionDataSchema = dataSchema;
    }

    @Nullable
    public Collection<Serializable[]> getSelectionResult() {
        return this._selectionResult;
    }

    public void setSelectionResult(@Nullable Collection<Serializable[]> rowEventsSet) {
        this._selectionResult = rowEventsSet;
    }

    @Nullable
    public AggregationFunctionContext[] getAggregationFunctionContexts() {
        return this._aggregationFunctionContexts;
    }

    public void setAggregationFunctionContexts(AggregationFunctionContext[] aggregationFunctionContexts) {
        this._aggregationFunctionContexts = aggregationFunctionContexts;
    }

    @Nullable
    public List<Object> getAggregationResult() {
        return this._aggregationResult;
    }

    public void setAggregationResults(@Nullable List<Object> aggregationResults) {
        this._aggregationResult = aggregationResults;
    }

    @Nullable
    public AggregationGroupByResult getAggregationGroupByResult() {
        return this._aggregationGroupByResult;
    }

    @Nullable
    public List<ProcessingException> getProcessingExceptions() {
        return this._processingExceptions;
    }

    public void setProcessingExceptions(@Nullable List<ProcessingException> processingExceptions) {
        this._processingExceptions = processingExceptions;
    }

    public void addToProcessingExceptions(@Nonnull ProcessingException processingException) {
        if (this._processingExceptions == null) {
            this._processingExceptions = new ArrayList<ProcessingException>();
        }
        this._processingExceptions.add(processingException);
    }

    public void setNumDocsScanned(long numDocsScanned) {
        this._numDocsScanned = numDocsScanned;
    }

    public void setNumEntriesScannedInFilter(long numEntriesScannedInFilter) {
        this._numEntriesScannedInFilter = numEntriesScannedInFilter;
    }

    public void setNumEntriesScannedPostFilter(long numEntriesScannedPostFilter) {
        this._numEntriesScannedPostFilter = numEntriesScannedPostFilter;
    }

    public long getNumSegmentsProcessed() {
        return this._numSegmentsProcessed;
    }

    public void setNumSegmentsProcessed(long numSegmentsProcessed) {
        this._numSegmentsProcessed = numSegmentsProcessed;
    }

    public long getNumSegmentsMatched() {
        return this._numSegmentsMatched;
    }

    public void setNumSegmentsMatched(long numSegmentsMatched) {
        this._numSegmentsMatched = numSegmentsMatched;
    }

    public void setNumTotalRawDocs(long numTotalRawDocs) {
        this._numTotalRawDocs = numTotalRawDocs;
    }

    public void setNumGroupsLimitReached(boolean numGroupsLimitReached) {
        this._numGroupsLimitReached = numGroupsLimitReached;
    }

    @Nonnull
    public DataTable getDataTable() throws Exception {
        if (this._selectionResult != null) {
            return this.getSelectionResultDataTable();
        }
        if (this._aggregationResult != null) {
            return this.getAggregationResultDataTable();
        }
        if (this._combinedAggregationGroupByResult != null) {
            return this.getAggregationGroupByResultDataTable();
        }
        if (this._processingExceptions != null && this._processingExceptions.size() > 0) {
            return this.getProcessingExceptionsDataTable();
        }
        throw new UnsupportedOperationException("No data inside IntermediateResultsBlock.");
    }

    @Nonnull
    private DataTable getSelectionResultDataTable() throws Exception {
        return this.attachMetadataToDataTable(SelectionOperatorUtils.getDataTableFromRows(this._selectionResult, this._selectionDataSchema));
    }

    @Nonnull
    private DataTable getAggregationResultDataTable() throws Exception {
        int numAggregationFunctions = this._aggregationFunctionContexts.length;
        String[] columnNames = new String[numAggregationFunctions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunctionContext aggregationFunctionContext = this._aggregationFunctionContexts[i];
            columnNames[i] = aggregationFunctionContext.getAggregationColumnName();
            columnDataTypes[i] = aggregationFunctionContext.getAggregationFunction().getIntermediateResultColumnType();
        }
        DataTableBuilder dataTableBuilder = new DataTableBuilder(new DataSchema(columnNames, columnDataTypes));
        dataTableBuilder.startRow();
        block6: for (int i = 0; i < numAggregationFunctions; ++i) {
            switch (columnDataTypes[i]) {
                case LONG: {
                    dataTableBuilder.setColumn(i, ((Number)this._aggregationResult.get(i)).longValue());
                    continue block6;
                }
                case DOUBLE: {
                    dataTableBuilder.setColumn(i, (Double)this._aggregationResult.get(i));
                    continue block6;
                }
                case OBJECT: {
                    dataTableBuilder.setColumn(i, this._aggregationResult.get(i));
                    continue block6;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported aggregation column data type: " + (Object)((Object)columnDataTypes[i]) + " for column: " + columnNames[i]);
                }
            }
        }
        dataTableBuilder.finishRow();
        DataTable dataTable = dataTableBuilder.build();
        return this.attachMetadataToDataTable(dataTable);
    }

    @Nonnull
    private DataTable getAggregationGroupByResultDataTable() throws Exception {
        String[] columnNames = new String[]{"functionName", "GroupByResultMap"};
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.STRING, DataSchema.ColumnDataType.OBJECT};
        DataTableBuilder dataTableBuilder = new DataTableBuilder(new DataSchema(columnNames, columnDataTypes));
        int numAggregationFunctions = this._aggregationFunctionContexts.length;
        for (int i = 0; i < numAggregationFunctions; ++i) {
            dataTableBuilder.startRow();
            AggregationFunctionContext aggregationFunctionContext = this._aggregationFunctionContexts[i];
            dataTableBuilder.setColumn(0, aggregationFunctionContext.getAggregationColumnName());
            dataTableBuilder.setColumn(1, this._combinedAggregationGroupByResult.get(i));
            dataTableBuilder.finishRow();
        }
        DataTable dataTable = dataTableBuilder.build();
        return this.attachMetadataToDataTable(dataTable);
    }

    private DataTable getProcessingExceptionsDataTable() {
        return this.attachMetadataToDataTable(new DataTableImplV2());
    }

    private DataTable attachMetadataToDataTable(DataTable dataTable) {
        dataTable.getMetadata().put("numDocsScanned", String.valueOf(this._numDocsScanned));
        dataTable.getMetadata().put("numEntriesScannedInFilter", String.valueOf(this._numEntriesScannedInFilter));
        dataTable.getMetadata().put("numEntriesScannedPostFilter", String.valueOf(this._numEntriesScannedPostFilter));
        dataTable.getMetadata().put("numSegmentsProcessed", String.valueOf(this._numSegmentsProcessed));
        dataTable.getMetadata().put("numSegmentsMatched", String.valueOf(this._numSegmentsMatched));
        dataTable.getMetadata().put("totalDocs", String.valueOf(this._numTotalRawDocs));
        if (this._numGroupsLimitReached) {
            dataTable.getMetadata().put("numGroupsLimitReached", "true");
        }
        if (this._processingExceptions != null && this._processingExceptions.size() > 0) {
            for (ProcessingException exception : this._processingExceptions) {
                dataTable.addException(exception);
            }
        }
        return dataTable;
    }

    @Override
    public .BlockDocIdSet getBlockDocIdSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockValSet getBlockValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public .BlockDocIdValueSet getBlockDocIdValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockMetadata getMetadata() {
        throw new UnsupportedOperationException();
    }
}

