/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks;

import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.pinot.;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Block;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docvalsets.TransformBlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.common.request.transform.TransformExpressionTree;

public class TransformBlock
implements Block {
    private final ProjectionBlock _projectionBlock;
    private final Map<TransformExpressionTree, TransformFunction> _transformFunctionMap;

    public TransformBlock(@Nonnull ProjectionBlock projectionBlock, @Nonnull Map<TransformExpressionTree, TransformFunction> transformFunctionMap) {
        this._projectionBlock = projectionBlock;
        this._transformFunctionMap = transformFunctionMap;
    }

    public int getNumDocs() {
        return this._projectionBlock.getNumDocs();
    }

    public BlockValSet getBlockValueSet(TransformExpressionTree expression) {
        if (expression.isColumn()) {
            return this._projectionBlock.getBlockValueSet(expression.getValue());
        }
        return new TransformBlockValSet(this._projectionBlock, this._transformFunctionMap.get(expression));
    }

    public BlockValSet getBlockValueSet(String column) {
        return this._projectionBlock.getBlockValueSet(column);
    }

    @Override
    public .BlockDocIdSet getBlockDocIdSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockValSet getBlockValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public .BlockDocIdValueSet getBlockDocIdValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockMetadata getMetadata() {
        throw new UnsupportedOperationException();
    }
}

