/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators;

import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockDocIdIterator;

public final class OrDocIdIterator
implements BlockDocIdIterator {
    private final BlockDocIdIterator[] _docIdIterators;
    private final int[] _nextDocIds;
    private final int _minDocId;
    private final int _maxDocId;
    private int _numNotExhaustedIterators;
    private int _currentDocId = -1;

    public OrDocIdIterator(BlockDocIdIterator[] docIdIterators, int minDocId, int maxDocId) {
        this._docIdIterators = docIdIterators;
        this._numNotExhaustedIterators = docIdIterators.length;
        this._nextDocIds = new int[this._numNotExhaustedIterators];
        for (int i = 0; i < this._numNotExhaustedIterators; ++i) {
            this._nextDocIds[i] = docIdIterators[i].advance(minDocId);
        }
        this._minDocId = minDocId;
        this._maxDocId = maxDocId;
        this.removeExhaustedIterators();
    }

    @Override
    public int next() {
        if (this._currentDocId == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        int nextDocId = Integer.MAX_VALUE;
        boolean hasExhaustedIterator = false;
        for (int i = 0; i < this._numNotExhaustedIterators; ++i) {
            int docId = this._nextDocIds[i];
            if (docId == this._currentDocId) {
                this._nextDocIds[i] = docId = this._docIdIterators[i].next();
            }
            if (docId != Integer.MIN_VALUE) {
                nextDocId = Math.min(nextDocId, docId);
                continue;
            }
            hasExhaustedIterator = true;
        }
        if (nextDocId > this._maxDocId) {
            this._currentDocId = Integer.MIN_VALUE;
        } else {
            this._currentDocId = nextDocId;
            if (hasExhaustedIterator) {
                this.removeExhaustedIterators();
            }
        }
        return this._currentDocId;
    }

    @Override
    public int advance(int targetDocId) {
        if (this._currentDocId == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (targetDocId > this._maxDocId) {
            this._currentDocId = Integer.MIN_VALUE;
            return Integer.MIN_VALUE;
        }
        if (targetDocId <= this._currentDocId) {
            return this._currentDocId;
        }
        if (targetDocId < this._minDocId) {
            targetDocId = this._minDocId;
        }
        int nextDocId = Integer.MAX_VALUE;
        boolean hasExhaustedIterator = false;
        for (int i = 0; i < this._numNotExhaustedIterators; ++i) {
            int docId = this._nextDocIds[i];
            if (docId < targetDocId) {
                this._nextDocIds[i] = docId = this._docIdIterators[i].advance(targetDocId);
            }
            if (docId != Integer.MIN_VALUE) {
                nextDocId = Math.min(nextDocId, docId);
                continue;
            }
            hasExhaustedIterator = true;
        }
        if (nextDocId > this._maxDocId) {
            this._currentDocId = Integer.MIN_VALUE;
        } else {
            this._currentDocId = nextDocId;
            if (hasExhaustedIterator) {
                this.removeExhaustedIterators();
            }
        }
        return this._currentDocId;
    }

    private void removeExhaustedIterators() {
        int i = 0;
        while (i < this._numNotExhaustedIterators) {
            if (this._nextDocIds[i] == Integer.MIN_VALUE) {
                --this._numNotExhaustedIterators;
                this._docIdIterators[i] = this._docIdIterators[this._numNotExhaustedIterators];
                this._nextDocIds[i] = this._nextDocIds[this._numNotExhaustedIterators];
                continue;
            }
            ++i;
        }
    }

    @Override
    public int currentDocId() {
        return this._currentDocId;
    }
}

