/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators;

import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockDocIdIterator;
import org.roaringbitmap.IntIterator;

public class RangelessBitmapDocIdIterator
implements BlockDocIdIterator {
    private IntIterator iterator;
    int currentDocId = -1;

    public RangelessBitmapDocIdIterator(IntIterator iterator) {
        this.iterator = iterator;
    }

    @Override
    public int currentDocId() {
        return this.currentDocId;
    }

    @Override
    public int next() {
        if (this.currentDocId == Integer.MIN_VALUE || !this.iterator.hasNext()) {
            this.currentDocId = Integer.MIN_VALUE;
            return Integer.MIN_VALUE;
        }
        this.currentDocId = this.iterator.next();
        return this.currentDocId;
    }

    @Override
    public int advance(int targetDocId) {
        if (targetDocId < this.currentDocId) {
            throw new IllegalArgumentException("Trying to move backwards to docId " + targetDocId + ", current position " + this.currentDocId);
        }
        if (this.currentDocId == targetDocId) {
            return this.currentDocId;
        }
        int curr = this.next();
        while (curr < targetDocId && curr != Integer.MIN_VALUE) {
            curr = this.next();
        }
        return curr;
    }
}

