/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators;

import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockSingleValIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.common.data.FieldSpec;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class SVScanDocIdIterator
implements ScanBasedDocIdIterator {
    private int _currentDocId = -1;
    private final BlockSingleValIterator _valueIterator;
    private int _startDocId;
    private int _endDocId;
    private PredicateEvaluator _evaluator;
    private String _datasourceName;
    private int _numEntriesScanned = 0;
    private final ValueMatcher _valueMatcher;

    public SVScanDocIdIterator(String datasourceName, BlockValSet blockValSet, BlockMetadata blockMetadata, PredicateEvaluator evaluator) {
        this._datasourceName = datasourceName;
        this._evaluator = evaluator;
        this._valueIterator = (BlockSingleValIterator)blockValSet.iterator();
        if (evaluator.isAlwaysFalse()) {
            this._currentDocId = Integer.MIN_VALUE;
            this.setStartDocId(Integer.MIN_VALUE);
            this.setEndDocId(Integer.MIN_VALUE);
        } else {
            this.setStartDocId(blockMetadata.getStartDocId());
            this.setEndDocId(blockMetadata.getEndDocId());
        }
        this._valueMatcher = evaluator.isDictionaryBased() ? new IntMatcher() : SVScanDocIdIterator.getValueMatcherForType(blockMetadata.getDataType());
        this._valueMatcher.setEvaluator(evaluator);
    }

    public void setStartDocId(int startDocId) {
        this._currentDocId = startDocId - 1;
        this._valueIterator.skipTo(startDocId);
        this._startDocId = startDocId;
    }

    public void setEndDocId(int endDocId) {
        this._endDocId = endDocId;
    }

    @Override
    public boolean isMatch(int docId) {
        if (this._currentDocId == Integer.MIN_VALUE) {
            return false;
        }
        this._valueIterator.skipTo(docId);
        ++this._numEntriesScanned;
        return this._valueMatcher.doesCurrentEntryMatch(this._valueIterator);
    }

    @Override
    public int advance(int targetDocId) {
        if (this._currentDocId == Integer.MIN_VALUE) {
            return this._currentDocId;
        }
        if (targetDocId < this._startDocId) {
            targetDocId = this._startDocId;
        } else if (targetDocId > this._endDocId) {
            this._currentDocId = Integer.MIN_VALUE;
        }
        if (this._currentDocId >= targetDocId) {
            return this._currentDocId;
        }
        this._currentDocId = targetDocId - 1;
        this._valueIterator.skipTo(targetDocId);
        return this.next();
    }

    @Override
    public int next() {
        if (this._currentDocId == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        while (this._valueIterator.hasNext() && this._currentDocId < this._endDocId) {
            ++this._currentDocId;
            ++this._numEntriesScanned;
            if (!this._valueMatcher.doesCurrentEntryMatch(this._valueIterator)) continue;
            return this._currentDocId;
        }
        this._currentDocId = Integer.MIN_VALUE;
        return Integer.MIN_VALUE;
    }

    @Override
    public int currentDocId() {
        return this._currentDocId;
    }

    public String toString() {
        return SVScanDocIdIterator.class.getSimpleName() + "[" + this._datasourceName + "]";
    }

    @Override
    public MutableRoaringBitmap applyAnd(MutableRoaringBitmap answer) {
        MutableRoaringBitmap result = new MutableRoaringBitmap();
        if (this._evaluator.isAlwaysFalse()) {
            return result;
        }
        IntIterator intIterator = answer.getIntIterator();
        int docId = -1;
        while (intIterator.hasNext() && docId < this._endDocId) {
            docId = intIterator.next();
            if (docId < this._startDocId) continue;
            this._valueIterator.skipTo(docId);
            ++this._numEntriesScanned;
            if (!this._valueMatcher.doesCurrentEntryMatch(this._valueIterator)) continue;
            result.add(docId);
        }
        return result;
    }

    @Override
    public int getNumEntriesScanned() {
        return this._numEntriesScanned;
    }

    private static ValueMatcher getValueMatcherForType(FieldSpec.DataType dataType) {
        switch (dataType) {
            case INT: {
                return new IntMatcher();
            }
            case LONG: {
                return new LongMatcher();
            }
            case FLOAT: {
                return new FloatMatcher();
            }
            case DOUBLE: {
                return new DoubleMatcher();
            }
            case STRING: {
                return new StringMatcher();
            }
        }
        throw new UnsupportedOperationException("Index without dictionary not supported for data type: " + (Object)((Object)dataType));
    }

    private static class StringMatcher
    extends ValueMatcher {
        private StringMatcher() {
        }

        @Override
        public boolean doesCurrentEntryMatch(BlockSingleValIterator valueIterator) {
            return this._evaluator.applySV(valueIterator.nextStringVal());
        }
    }

    private static class DoubleMatcher
    extends ValueMatcher {
        private DoubleMatcher() {
        }

        @Override
        public boolean doesCurrentEntryMatch(BlockSingleValIterator valueIterator) {
            return this._evaluator.applySV(valueIterator.nextDoubleVal());
        }
    }

    private static class FloatMatcher
    extends ValueMatcher {
        private FloatMatcher() {
        }

        @Override
        public boolean doesCurrentEntryMatch(BlockSingleValIterator valueIterator) {
            return this._evaluator.applySV(valueIterator.nextFloatVal());
        }
    }

    private static class LongMatcher
    extends ValueMatcher {
        private LongMatcher() {
        }

        @Override
        public boolean doesCurrentEntryMatch(BlockSingleValIterator valueIterator) {
            return this._evaluator.applySV(valueIterator.nextLongVal());
        }
    }

    private static class IntMatcher
    extends ValueMatcher {
        private IntMatcher() {
        }

        @Override
        public boolean doesCurrentEntryMatch(BlockSingleValIterator valueIterator) {
            return this._evaluator.applySV(valueIterator.nextIntVal());
        }
    }

    private static abstract class ValueMatcher {
        protected PredicateEvaluator _evaluator;

        private ValueMatcher() {
        }

        public void setEvaluator(PredicateEvaluator evaluator) {
            this._evaluator = evaluator;
        }

        abstract boolean doesCurrentEntryMatch(BlockSingleValIterator var1);
    }
}

