/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators;

import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockDocIdIterator;

public final class SizeBasedDocIdIterator
implements BlockDocIdIterator {
    private final int _maxDocId;
    private int _currentDocId = -1;

    public SizeBasedDocIdIterator(int maxDocId) {
        this._maxDocId = maxDocId;
    }

    @Override
    public int next() {
        if (this._currentDocId >= this._maxDocId) {
            return Integer.MIN_VALUE;
        }
        return ++this._currentDocId;
    }

    @Override
    public int advance(int targetDocId) {
        this._currentDocId = targetDocId;
        if (this._currentDocId >= this._maxDocId) {
            return Integer.MIN_VALUE;
        }
        return this._currentDocId;
    }

    @Override
    public int currentDocId() {
        return this._currentDocId;
    }
}

