/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.AndDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.BitmapDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.RangelessBitmapDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.ScanBasedMultiValueDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.ScanBasedSingleValueDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.SortedDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.util.SortedRangeIntersection;
import org.apache.pinot.common.utils.Pairs;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AndBlockDocIdSet
implements FilterBlockDocIdSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AndBlockDocIdSet.class);
    private List<FilterBlockDocIdSet> blockDocIdSets;
    private int minDocId = Integer.MIN_VALUE;
    private int maxDocId = Integer.MAX_VALUE;
    MutableRoaringBitmap answer = null;
    boolean validate = false;

    public AndBlockDocIdSet(List<FilterBlockDocIdSet> blockDocIdSets) {
        this.blockDocIdSets = blockDocIdSets;
        this.updateMinMaxRange();
    }

    private void updateMinMaxRange() {
        for (FilterBlockDocIdSet blockDocIdSet : this.blockDocIdSets) {
            this.minDocId = Math.max(this.minDocId, blockDocIdSet.getMinDocId());
            this.maxDocId = Math.min(this.maxDocId, blockDocIdSet.getMaxDocId());
        }
        for (FilterBlockDocIdSet blockDocIdSet : this.blockDocIdSets) {
            blockDocIdSet.setStartDocId(this.minDocId);
            blockDocIdSet.setEndDocId(this.maxDocId);
        }
    }

    @Override
    public BlockDocIdIterator iterator() {
        if (this.validate) {
            int docId2;
            int docId1;
            BlockDocIdIterator slowIterator = this.slowIterator();
            BlockDocIdIterator fastIterator = this.fastIterator();
            ArrayList<Integer> matchedIds = new ArrayList<Integer>();
            do {
                if ((docId1 = slowIterator.next()) != (docId2 = fastIterator.next())) {
                    LOGGER.error("ERROR docId1:" + docId1 + " docId2:" + docId2);
                    continue;
                }
                matchedIds.add(docId1);
            } while (docId1 != Integer.MIN_VALUE && docId2 != Integer.MIN_VALUE);
            this.answer = null;
        }
        return this.fastIterator();
    }

    /*
     * WARNING - void declaration
     */
    public BlockDocIdIterator slowIterator() {
        BlockDocIdIterator[] docIdIterators;
        ArrayList<BlockDocIdIterator> rawIterators = new ArrayList<BlockDocIdIterator>();
        boolean useBitmapBasedIntersection = false;
        for (BlockDocIdSet blockDocIdSet : this.blockDocIdSets) {
            if (!(blockDocIdSet instanceof BitmapDocIdSet)) continue;
            useBitmapBasedIntersection = true;
        }
        if (useBitmapBasedIntersection) {
            IntIterator intIterator;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (BlockDocIdSet blockDocIdSet : this.blockDocIdSets) {
                if (blockDocIdSet instanceof SortedDocIdSet) {
                    MutableRoaringBitmap bitmap = new MutableRoaringBitmap();
                    SortedDocIdSet sortedDocIdSet = (SortedDocIdSet)blockDocIdSet;
                    List pairs = (List)sortedDocIdSet.getRaw();
                    for (Pairs.IntPair pair : pairs) {
                        bitmap.add(pair.getLeft(), pair.getRight() + 1);
                    }
                    arrayList.add(bitmap);
                    continue;
                }
                if (blockDocIdSet instanceof BitmapDocIdSet) {
                    BitmapDocIdSet bitmapDocIdSet = (BitmapDocIdSet)blockDocIdSet;
                    ImmutableRoaringBitmap childBitmap = (ImmutableRoaringBitmap)bitmapDocIdSet.getRaw();
                    arrayList.add(childBitmap);
                    continue;
                }
                BlockDocIdIterator iterator = blockDocIdSet.iterator();
                rawIterators.add(iterator);
            }
            if (arrayList.size() > 1) {
                MutableRoaringBitmap mutableRoaringBitmap = (MutableRoaringBitmap)((ImmutableRoaringBitmap)arrayList.get(0)).clone();
                for (int i = 1; i < arrayList.size(); ++i) {
                    mutableRoaringBitmap.and((ImmutableRoaringBitmap)arrayList.get(i));
                }
                intIterator = mutableRoaringBitmap.getIntIterator();
            } else {
                intIterator = ((ImmutableRoaringBitmap)arrayList.get(0)).getIntIterator();
            }
            BitmapDocIdIterator bitmapDocIdIterator = new BitmapDocIdIterator(intIterator);
            bitmapDocIdIterator.setStartDocId(this.minDocId);
            bitmapDocIdIterator.setEndDocId(this.maxDocId);
            rawIterators.add(0, bitmapDocIdIterator);
            docIdIterators = new BlockDocIdIterator[rawIterators.size()];
            rawIterators.toArray(docIdIterators);
        } else {
            void var4_7;
            docIdIterators = new BlockDocIdIterator[this.blockDocIdSets.size()];
            boolean bl = false;
            while (var4_7 < this.blockDocIdSets.size()) {
                docIdIterators[var4_7] = this.blockDocIdSets.get((int)var4_7).iterator();
                ++var4_7;
            }
        }
        return new AndDocIdIterator(docIdIterators);
    }

    /*
     * WARNING - void declaration
     */
    public BlockDocIdIterator fastIterator() {
        long start = System.currentTimeMillis();
        ArrayList<List<Pairs.IntPair>> sortedRangeSets = new ArrayList<List<Pairs.IntPair>>();
        ArrayList<ImmutableRoaringBitmap> childBitmaps = new ArrayList<ImmutableRoaringBitmap>();
        ArrayList<FilterBlockDocIdSet> scanBasedDocIdSets = new ArrayList<FilterBlockDocIdSet>();
        ArrayList<BlockDocIdIterator> remainingIterators = new ArrayList<BlockDocIdIterator>();
        for (BlockDocIdSet blockDocIdSet : this.blockDocIdSets) {
            if (blockDocIdSet instanceof SortedDocIdSet) {
                SortedDocIdSet sortedDocIdSet = (SortedDocIdSet)blockDocIdSet;
                List pairs = (List)sortedDocIdSet.getRaw();
                sortedRangeSets.add(pairs);
                continue;
            }
            if (blockDocIdSet instanceof BitmapDocIdSet) {
                BitmapDocIdSet bitmapDocIdSet = (BitmapDocIdSet)blockDocIdSet;
                ImmutableRoaringBitmap childBitmap = (ImmutableRoaringBitmap)bitmapDocIdSet.getRaw();
                childBitmaps.add(childBitmap);
                continue;
            }
            if (blockDocIdSet instanceof ScanBasedSingleValueDocIdSet) {
                scanBasedDocIdSets.add((ScanBasedSingleValueDocIdSet)blockDocIdSet);
                continue;
            }
            if (blockDocIdSet instanceof ScanBasedMultiValueDocIdSet) {
                scanBasedDocIdSets.add((ScanBasedMultiValueDocIdSet)blockDocIdSet);
                continue;
            }
            remainingIterators.add(blockDocIdSet.iterator());
        }
        if (childBitmaps.size() == 0 && sortedRangeSets.size() == 0) {
            void var8_12;
            BlockDocIdIterator[] docIdIterators = new BlockDocIdIterator[this.blockDocIdSets.size()];
            boolean bl = false;
            while (var8_12 < this.blockDocIdSets.size()) {
                docIdIterators[var8_12] = this.blockDocIdSets.get((int)var8_12).iterator();
                ++var8_12;
            }
            return new AndDocIdIterator(docIdIterators);
        }
        if (sortedRangeSets.size() > 0) {
            List<Pairs.IntPair> pairList = SortedRangeIntersection.intersectSortedRangeSets(sortedRangeSets);
            this.answer = new MutableRoaringBitmap();
            for (Pairs.IntPair pair : pairList) {
                this.answer.add(pair.getLeft(), pair.getRight() + 1);
            }
        }
        if (childBitmaps.size() > 0) {
            if (this.answer == null) {
                this.answer = ((ImmutableRoaringBitmap)childBitmaps.get(0)).toMutableRoaringBitmap();
                for (int i = 1; i < childBitmaps.size(); ++i) {
                    this.answer.and((ImmutableRoaringBitmap)childBitmaps.get(i));
                }
            } else {
                for (int i = 0; i < childBitmaps.size(); ++i) {
                    this.answer.and((ImmutableRoaringBitmap)childBitmaps.get(i));
                }
            }
        }
        assert (this.answer != null) : "sortedRangeSets=" + sortedRangeSets.size() + ",childBitmaps=" + childBitmaps.size();
        for (FilterBlockDocIdSet filterBlockDocIdSet : scanBasedDocIdSets) {
            ScanBasedDocIdIterator iterator = (ScanBasedDocIdIterator)filterBlockDocIdSet.iterator();
            MutableRoaringBitmap scanAnswer = iterator.applyAnd(this.answer);
            this.answer.and((ImmutableRoaringBitmap)scanAnswer);
        }
        long end = System.currentTimeMillis();
        LOGGER.debug("Time to evaluate and Filter:{}", (Object)(end - start));
        RangelessBitmapDocIdIterator answerDocIdIterator = new RangelessBitmapDocIdIterator(this.answer.getIntIterator());
        if (remainingIterators.size() == 0) {
            return answerDocIdIterator;
        }
        BlockDocIdIterator[] docIdIterators = new BlockDocIdIterator[remainingIterators.size() + 1];
        docIdIterators[0] = answerDocIdIterator;
        for (int i = 0; i < remainingIterators.size(); ++i) {
            docIdIterators[i + 1] = (BlockDocIdIterator)remainingIterators.get(i);
        }
        return new AndDocIdIterator(docIdIterators);
    }

    @Override
    public <T> T getRaw() {
        return (T)this.answer;
    }

    @Override
    public int getMinDocId() {
        return this.minDocId;
    }

    @Override
    public int getMaxDocId() {
        return this.maxDocId;
    }

    @Override
    public void setStartDocId(int startDocId) {
        this.minDocId = Math.max(this.minDocId, startDocId);
        this.updateMinMaxRange();
    }

    @Override
    public void setEndDocId(int endDocId) {
        this.maxDocId = Math.min(this.maxDocId, endDocId);
        this.updateMinMaxRange();
    }

    @Override
    public long getNumEntriesScannedInFilter() {
        long numEntriesScannedInFilter = 0L;
        for (FilterBlockDocIdSet blockDocIdSet : this.blockDocIdSets) {
            numEntriesScannedInFilter += blockDocIdSet.getNumEntriesScannedInFilter();
        }
        return numEntriesScannedInFilter;
    }
}

