/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.filter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.commons.lang3.StringUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Predicate;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.AndFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.BitmapBasedFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.EmptyFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.MatchAllFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.OrFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.ScanBasedFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.SortedInvertedIndexBasedFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;

public class FilterOperatorUtils {
    public static final String USE_SCAN_REORDER_OPTIMIZATION = "useScanReorderOpt";

    private FilterOperatorUtils() {
    }

    public static BaseFilterOperator getLeafFilterOperator(PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs) {
        if (predicateEvaluator.isAlwaysFalse()) {
            return EmptyFilterOperator.getInstance();
        }
        if (predicateEvaluator.isAlwaysTrue()) {
            return new MatchAllFilterOperator(numDocs);
        }
        int startDocId = 0;
        int endDocId = numDocs - 1;
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        Predicate.Type predicateType = predicateEvaluator.getPredicateType();
        if (dataSourceMetadata.hasInvertedIndex() && predicateType != Predicate.Type.RANGE && predicateType != Predicate.Type.REGEXP_LIKE) {
            if (dataSourceMetadata.isSorted()) {
                return new SortedInvertedIndexBasedFilterOperator(predicateEvaluator, dataSource, startDocId, endDocId);
            }
            return new BitmapBasedFilterOperator(predicateEvaluator, dataSource, startDocId, endDocId);
        }
        return new ScanBasedFilterOperator(predicateEvaluator, dataSource, startDocId, endDocId);
    }

    public static BaseFilterOperator getAndFilterOperator(List<BaseFilterOperator> filterOperators, int numDocs, @Nullable Map<String, String> debugOptions) {
        ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(filterOperators.size());
        for (BaseFilterOperator filterOperator : filterOperators) {
            if (filterOperator.isResultEmpty()) {
                return EmptyFilterOperator.getInstance();
            }
            if (filterOperator.isResultMatchingAll()) continue;
            childFilterOperators.add(filterOperator);
        }
        int numChildFilterOperators = childFilterOperators.size();
        if (numChildFilterOperators == 0) {
            return new MatchAllFilterOperator(numDocs);
        }
        if (numChildFilterOperators == 1) {
            return (BaseFilterOperator)childFilterOperators.get(0);
        }
        FilterOperatorUtils.reorderAndFilterChildOperators(childFilterOperators, debugOptions);
        return new AndFilterOperator(childFilterOperators);
    }

    public static BaseFilterOperator getOrFilterOperator(List<BaseFilterOperator> filterOperators, int numDocs, @Nullable Map<String, String> debugOptions) {
        ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(filterOperators.size());
        for (BaseFilterOperator filterOperator : filterOperators) {
            if (filterOperator.isResultMatchingAll()) {
                return new MatchAllFilterOperator(numDocs);
            }
            if (filterOperator.isResultEmpty()) continue;
            childFilterOperators.add(filterOperator);
        }
        int numChildFilterOperators = childFilterOperators.size();
        if (numChildFilterOperators == 0) {
            return EmptyFilterOperator.getInstance();
        }
        if (numChildFilterOperators == 1) {
            return (BaseFilterOperator)childFilterOperators.get(0);
        }
        return new OrFilterOperator(childFilterOperators);
    }

    private static void reorderAndFilterChildOperators(List<BaseFilterOperator> filterOperators, final @Nullable Map<String, String> debugOptions) {
        filterOperators.sort(new Comparator<BaseFilterOperator>(){

            @Override
            public int compare(BaseFilterOperator o1, BaseFilterOperator o2) {
                return this.getPriority(o1) - this.getPriority(o2);
            }

            int getPriority(BaseFilterOperator filterOperator) {
                if (filterOperator instanceof SortedInvertedIndexBasedFilterOperator) {
                    return 0;
                }
                if (filterOperator instanceof BitmapBasedFilterOperator) {
                    return 1;
                }
                if (filterOperator instanceof AndFilterOperator) {
                    return 2;
                }
                if (filterOperator instanceof OrFilterOperator) {
                    return 3;
                }
                if (filterOperator instanceof ScanBasedFilterOperator) {
                    return FilterOperatorUtils.getScanBasedFilterPriority((ScanBasedFilterOperator)filterOperator, 4, debugOptions);
                }
                throw new IllegalStateException(filterOperator.getClass().getSimpleName() + " should not be reordered, remove it from the list before calling this method");
            }
        });
    }

    private static int getScanBasedFilterPriority(ScanBasedFilterOperator scanBasedFilterOperator, int basePriority, @Nullable Map<String, String> debugOptions) {
        boolean disabled = false;
        if (debugOptions != null && StringUtils.compareIgnoreCase(debugOptions.get(USE_SCAN_REORDER_OPTIMIZATION), "false") == 0) {
            disabled = true;
        }
        DataSourceMetadata metadata = scanBasedFilterOperator.getDataSourceMetadata();
        if (disabled || metadata == null || metadata.isSingleValue()) {
            return basePriority;
        }
        return basePriority + 1;
    }
}

