/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.filter;

import org.apache.pinot.common.utils.Pairs;

public class IntRanges {
    private static final boolean ENABLE_PRECONDITION_CHECKS = false;

    public static void clip(Pairs.IntPair range, int lowerBound, int upperBound) {
        range.setLeft(Math.max(range.getLeft(), lowerBound));
        range.setRight(Math.min(range.getRight(), upperBound));
    }

    public static boolean isInvalid(Pairs.IntPair range) {
        return range.getRight() < range.getLeft();
    }

    public static boolean rangesAreMergeable(Pairs.IntPair firstRange, Pairs.IntPair secondRange) {
        boolean rangesAreAtLeastOneUnitApart = firstRange.getRight() < secondRange.getLeft() - 1 || secondRange.getRight() < firstRange.getLeft() - 1;
        return !rangesAreAtLeastOneUnitApart;
    }

    public static void mergeIntoFirst(Pairs.IntPair firstRange, Pairs.IntPair secondRange) {
        firstRange.setLeft(Math.min(firstRange.getLeft(), secondRange.getLeft()));
        firstRange.setRight(Math.max(firstRange.getRight(), secondRange.getRight()));
    }
}

