/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docidsets.OrBlockDocIdSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.BaseFilterOperator;

public class OrFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "OrFilterOperator";
    private List<BaseFilterOperator> _filterOperators;

    OrFilterOperator(List<BaseFilterOperator> filterOperators) {
        for (BaseFilterOperator filterOperator : filterOperators) {
            Preconditions.checkArgument(!filterOperator.isResultEmpty() && !filterOperator.isResultMatchingAll());
        }
        this._filterOperators = filterOperators;
    }

    @Override
    protected FilterBlock getNextBlock() {
        ArrayList<FilterBlockDocIdSet> filterBlockDocIdSets = new ArrayList<FilterBlockDocIdSet>(this._filterOperators.size());
        for (BaseFilterOperator filterOperator : this._filterOperators) {
            filterBlockDocIdSets.add(((FilterBlock)filterOperator.nextBlock()).getBlockDocIdSet());
        }
        return new FilterBlock(new OrBlockDocIdSet(filterBlockDocIdSets));
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }
}

