/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate;

import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Predicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.InPredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.utils.HashUtil;

public class InPredicateEvaluatorFactory {
    private InPredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(InPredicate inPredicate, Dictionary dictionary) {
        return new DictionaryBasedInPredicateEvaluator(inPredicate, dictionary);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(InPredicate inPredicate, FieldSpec.DataType dataType) {
        switch (dataType) {
            case INT: {
                return new IntRawValueBasedInPredicateEvaluator(inPredicate);
            }
            case LONG: {
                return new LongRawValueBasedInPredicateEvaluator(inPredicate);
            }
            case FLOAT: {
                return new FloatRawValueBasedInPredicateEvaluator(inPredicate);
            }
            case DOUBLE: {
                return new DoubleRawValueBasedInPredicateEvaluator(inPredicate);
            }
            case STRING: {
                return new StringRawValueBasedInPredicateEvaluator(inPredicate);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)dataType));
    }

    private static final class StringRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final Set<String> _matchingValues;

        StringRawValueBasedInPredicateEvaluator(InPredicate inPredicate) {
            String[] values = inPredicate.getValues();
            this._matchingValues = new HashSet<String>(HashUtil.getMinHashSetSize(values.length));
            Collections.addAll(this._matchingValues, values);
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.IN;
        }

        @Override
        public boolean applySV(String value) {
            return this._matchingValues.contains(value);
        }
    }

    private static final class DoubleRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final DoubleSet _matchingValues;

        DoubleRawValueBasedInPredicateEvaluator(InPredicate inPredicate) {
            String[] values = inPredicate.getValues();
            this._matchingValues = new DoubleOpenHashSet(HashUtil.getMinHashSetSize(values.length));
            for (String value : values) {
                this._matchingValues.add(Double.parseDouble(value));
            }
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.IN;
        }

        @Override
        public boolean applySV(double value) {
            return this._matchingValues.contains(value);
        }
    }

    private static final class FloatRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final FloatSet _matchingValues;

        FloatRawValueBasedInPredicateEvaluator(InPredicate inPredicate) {
            String[] values = inPredicate.getValues();
            this._matchingValues = new FloatOpenHashSet(HashUtil.getMinHashSetSize(values.length));
            for (String value : values) {
                this._matchingValues.add(Float.parseFloat(value));
            }
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.IN;
        }

        @Override
        public boolean applySV(float value) {
            return this._matchingValues.contains(value);
        }
    }

    private static final class LongRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final LongSet _matchingValues;

        LongRawValueBasedInPredicateEvaluator(InPredicate predicate) {
            String[] values = predicate.getValues();
            this._matchingValues = new LongOpenHashSet(HashUtil.getMinHashSetSize(values.length));
            for (String value : values) {
                this._matchingValues.add(Long.parseLong(value));
            }
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.IN;
        }

        @Override
        public boolean applySV(long value) {
            return this._matchingValues.contains(value);
        }
    }

    private static final class IntRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final IntSet _matchingValues;

        IntRawValueBasedInPredicateEvaluator(InPredicate inPredicate) {
            String[] values = inPredicate.getValues();
            this._matchingValues = new IntOpenHashSet(HashUtil.getMinHashSetSize(values.length));
            for (String value : values) {
                this._matchingValues.add(Integer.parseInt(value));
            }
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.IN;
        }

        @Override
        public boolean applySV(int value) {
            return this._matchingValues.contains(value);
        }
    }

    private static final class DictionaryBasedInPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final IntSet _matchingDictIdSet;
        final int _numMatchingDictIds;
        int[] _matchingDictIds;

        DictionaryBasedInPredicateEvaluator(InPredicate inPredicate, Dictionary dictionary) {
            String[] values = inPredicate.getValues();
            this._matchingDictIdSet = new IntOpenHashSet(HashUtil.getMinHashSetSize(values.length));
            for (String value : values) {
                int dictId = dictionary.indexOf(value);
                if (dictId < 0) continue;
                this._matchingDictIdSet.add(dictId);
            }
            this._numMatchingDictIds = this._matchingDictIdSet.size();
            if (this._numMatchingDictIds == 0) {
                this._alwaysFalse = true;
            } else if (dictionary.length() == this._numMatchingDictIds) {
                this._alwaysTrue = true;
            }
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.IN;
        }

        @Override
        public boolean applySV(int dictId) {
            return this._matchingDictIdSet.contains(dictId);
        }

        @Override
        public int getNumMatchingDictIds() {
            return this._numMatchingDictIds;
        }

        @Override
        public int[] getMatchingDictIds() {
            if (this._matchingDictIds == null) {
                this._matchingDictIds = this._matchingDictIdSet.toIntArray();
            }
            return this._matchingDictIds;
        }
    }
}

