/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate;

import org.apache.pinot.$internal.org.apache.pinot.core.common.Predicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.NEqPredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.common.data.FieldSpec;

public class NotEqualsPredicateEvaluatorFactory {
    private NotEqualsPredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(NEqPredicate nEqPredicate, Dictionary dictionary) {
        return new DictionaryBasedNeqPredicateEvaluator(nEqPredicate, dictionary);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(NEqPredicate nEqPredicate, FieldSpec.DataType dataType) {
        switch (dataType) {
            case INT: {
                return new IntRawValueBasedNeqPredicateEvaluator(nEqPredicate);
            }
            case LONG: {
                return new LongRawValueBasedNeqPredicateEvaluator(nEqPredicate);
            }
            case FLOAT: {
                return new FloatRawValueBasedNeqPredicateEvaluator(nEqPredicate);
            }
            case DOUBLE: {
                return new DoubleRawValueBasedNeqPredicateEvaluator(nEqPredicate);
            }
            case STRING: {
                return new StringRawValueBasedNeqPredicateEvaluator(nEqPredicate);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)dataType));
    }

    private static final class StringRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final String _nonMatchingValue;

        StringRawValueBasedNeqPredicateEvaluator(NEqPredicate nEqPredicate) {
            this._nonMatchingValue = nEqPredicate.getNotEqualsValue();
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NEQ;
        }

        @Override
        public boolean applySV(String value) {
            return !this._nonMatchingValue.equals(value);
        }
    }

    private static final class DoubleRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final double _nonMatchingValue;

        DoubleRawValueBasedNeqPredicateEvaluator(NEqPredicate nEqPredicate) {
            this._nonMatchingValue = Double.parseDouble(nEqPredicate.getNotEqualsValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NEQ;
        }

        @Override
        public boolean applySV(double value) {
            return this._nonMatchingValue != value;
        }
    }

    private static final class FloatRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final float _nonMatchingValue;

        FloatRawValueBasedNeqPredicateEvaluator(NEqPredicate nEqPredicate) {
            this._nonMatchingValue = Float.parseFloat(nEqPredicate.getNotEqualsValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NEQ;
        }

        @Override
        public boolean applySV(float value) {
            return this._nonMatchingValue != value;
        }
    }

    private static final class LongRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final long _nonMatchingValue;

        LongRawValueBasedNeqPredicateEvaluator(NEqPredicate nEqPredicate) {
            this._nonMatchingValue = Long.parseLong(nEqPredicate.getNotEqualsValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NEQ;
        }

        @Override
        public boolean applySV(long value) {
            return this._nonMatchingValue != value;
        }
    }

    private static final class IntRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final int _nonMatchingValue;

        IntRawValueBasedNeqPredicateEvaluator(NEqPredicate nEqPredicate) {
            this._nonMatchingValue = Integer.parseInt(nEqPredicate.getNotEqualsValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NEQ;
        }

        @Override
        public boolean applySV(int value) {
            return this._nonMatchingValue != value;
        }
    }

    private static final class DictionaryBasedNeqPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final int _nonMatchingDictId;
        final int[] _nonMatchingDictIds;
        final Dictionary _dictionary;
        int[] _matchingDictIds;

        DictionaryBasedNeqPredicateEvaluator(NEqPredicate nEqPredicate, Dictionary dictionary) {
            this._nonMatchingDictId = dictionary.indexOf(nEqPredicate.getNotEqualsValue());
            if (this._nonMatchingDictId >= 0) {
                this._nonMatchingDictIds = new int[]{this._nonMatchingDictId};
                if (dictionary.length() == 1) {
                    this._alwaysFalse = true;
                }
            } else {
                this._nonMatchingDictIds = new int[0];
                this._alwaysTrue = true;
            }
            this._dictionary = dictionary;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NEQ;
        }

        @Override
        public boolean applySV(int dictId) {
            return this._nonMatchingDictId != dictId;
        }

        @Override
        public int[] getMatchingDictIds() {
            block4: {
                if (this._matchingDictIds != null) break block4;
                int dictionarySize = this._dictionary.length();
                if (this._nonMatchingDictId >= 0) {
                    this._matchingDictIds = new int[dictionarySize - 1];
                    int index = 0;
                    for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                        if (dictId == this._nonMatchingDictId) continue;
                        this._matchingDictIds[index++] = dictId;
                    }
                } else {
                    this._matchingDictIds = new int[dictionarySize];
                    for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                        this._matchingDictIds[dictId] = dictId;
                    }
                }
            }
            return this._matchingDictIds;
        }

        @Override
        public int[] getNonMatchingDictIds() {
            return this._nonMatchingDictIds;
        }
    }
}

