/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate;

import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Predicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.NotInPredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.utils.HashUtil;

public class NotInPredicateEvaluatorFactory {
    private NotInPredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(NotInPredicate notInPredicate, Dictionary dictionary) {
        return new DictionaryBasedNotInPredicateEvaluator(notInPredicate, dictionary);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(NotInPredicate notInPredicate, FieldSpec.DataType dataType) {
        switch (dataType) {
            case INT: {
                return new IntRawValueBasedNotInPredicateEvaluator(notInPredicate);
            }
            case LONG: {
                return new LongRawValueBasedNotInPredicateEvaluator(notInPredicate);
            }
            case FLOAT: {
                return new FloatRawValueBasedNotInPredicateEvaluator(notInPredicate);
            }
            case DOUBLE: {
                return new DoubleRawValueBasedNotInPredicateEvaluator(notInPredicate);
            }
            case STRING: {
                return new StringRawValueBasedNotInPredicateEvaluator(notInPredicate);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)dataType));
    }

    private static final class StringRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final Set<String> _nonMatchingValues;

        StringRawValueBasedNotInPredicateEvaluator(NotInPredicate notInPredicate) {
            String[] values = notInPredicate.getValues();
            this._nonMatchingValues = new HashSet<String>(HashUtil.getMinHashSetSize(values.length));
            Collections.addAll(this._nonMatchingValues, values);
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_IN;
        }

        @Override
        public boolean applySV(String value) {
            return !this._nonMatchingValues.contains(value);
        }
    }

    private static final class DoubleRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final DoubleSet _nonMatchingValues;

        DoubleRawValueBasedNotInPredicateEvaluator(NotInPredicate notInPredicate) {
            String[] values = notInPredicate.getValues();
            this._nonMatchingValues = new DoubleOpenHashSet(HashUtil.getMinHashSetSize(values.length));
            for (String value : values) {
                this._nonMatchingValues.add(Double.parseDouble(value));
            }
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_IN;
        }

        @Override
        public boolean applySV(double value) {
            return !this._nonMatchingValues.contains(value);
        }
    }

    private static final class FloatRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final FloatSet _nonMatchingValues;

        FloatRawValueBasedNotInPredicateEvaluator(NotInPredicate notInPredicate) {
            String[] values = notInPredicate.getValues();
            this._nonMatchingValues = new FloatOpenHashSet(HashUtil.getMinHashSetSize(values.length));
            for (String value : values) {
                this._nonMatchingValues.add(Float.parseFloat(value));
            }
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_IN;
        }

        @Override
        public boolean applySV(float value) {
            return !this._nonMatchingValues.contains(value);
        }
    }

    private static final class LongRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final LongSet _nonMatchingValues;

        LongRawValueBasedNotInPredicateEvaluator(NotInPredicate notInPredicate) {
            String[] values = notInPredicate.getValues();
            this._nonMatchingValues = new LongOpenHashSet(values.length);
            for (String value : values) {
                this._nonMatchingValues.add(Long.parseLong(value));
            }
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_IN;
        }

        @Override
        public boolean applySV(long value) {
            return !this._nonMatchingValues.contains(value);
        }
    }

    private static final class IntRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final IntSet _nonMatchingValues;

        IntRawValueBasedNotInPredicateEvaluator(NotInPredicate notInPredicate) {
            String[] values = notInPredicate.getValues();
            this._nonMatchingValues = new IntOpenHashSet(HashUtil.getMinHashSetSize(values.length));
            for (String value : values) {
                this._nonMatchingValues.add(Integer.parseInt(value));
            }
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_IN;
        }

        @Override
        public boolean applySV(int value) {
            return !this._nonMatchingValues.contains(value);
        }
    }

    public static final class DictionaryBasedNotInPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final IntSet _nonMatchingDictIdSet;
        final int _numNonMatchingDictIds;
        final Dictionary _dictionary;
        int[] _matchingDictIds;
        int[] _nonMatchingDictIds;

        DictionaryBasedNotInPredicateEvaluator(NotInPredicate notInPredicate, Dictionary dictionary) {
            String[] values = notInPredicate.getValues();
            this._nonMatchingDictIdSet = new IntOpenHashSet(HashUtil.getMinHashSetSize(values.length));
            for (String value : values) {
                int dictId = dictionary.indexOf(value);
                if (dictId < 0) continue;
                this._nonMatchingDictIdSet.add(dictId);
            }
            this._numNonMatchingDictIds = this._nonMatchingDictIdSet.size();
            if (this._numNonMatchingDictIds == 0) {
                this._alwaysTrue = true;
            } else if (dictionary.length() == this._numNonMatchingDictIds) {
                this._alwaysFalse = true;
            }
            this._dictionary = dictionary;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_IN;
        }

        @Override
        public boolean applySV(int dictId) {
            return !this._nonMatchingDictIdSet.contains(dictId);
        }

        @Override
        public int[] getMatchingDictIds() {
            if (this._matchingDictIds == null) {
                int dictionarySize = this._dictionary.length();
                this._matchingDictIds = new int[dictionarySize - this._numNonMatchingDictIds];
                int index = 0;
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    if (this._nonMatchingDictIdSet.contains(dictId)) continue;
                    this._matchingDictIds[index++] = dictId;
                }
            }
            return this._matchingDictIds;
        }

        @Override
        public int getNumNonMatchingDictIds() {
            return this._numNonMatchingDictIds;
        }

        @Override
        public int[] getNonMatchingDictIds() {
            if (this._nonMatchingDictIds == null) {
                this._nonMatchingDictIds = this._nonMatchingDictIdSet.toIntArray();
            }
            return this._nonMatchingDictIds;
        }
    }
}

