/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Predicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.RangePredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.MutableDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.ImmutableDictionaryReader;
import org.apache.pinot.common.data.FieldSpec;

public class RangePredicateEvaluatorFactory {
    private RangePredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(RangePredicate rangePredicate, Dictionary dictionary) {
        if (dictionary instanceof ImmutableDictionaryReader) {
            return new OfflineDictionaryBasedRangePredicateEvaluator(rangePredicate, (ImmutableDictionaryReader)dictionary);
        }
        return new RealtimeDictionaryBasedRangePredicateEvaluator(rangePredicate, (MutableDictionary)dictionary);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(RangePredicate rangePredicate, FieldSpec.DataType dataType) {
        switch (dataType) {
            case INT: {
                return new IntRawValueBasedRangePredicateEvaluator(rangePredicate);
            }
            case LONG: {
                return new LongRawValueBasedRangePredicateEvaluator(rangePredicate);
            }
            case FLOAT: {
                return new FloatRawValueBasedRangePredicateEvaluator(rangePredicate);
            }
            case DOUBLE: {
                return new DoubleRawValueBasedRangePredicateEvaluator(rangePredicate);
            }
            case STRING: {
                return new StringRawValueBasedRangePredicateEvaluator(rangePredicate);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)dataType));
    }

    private static final class StringRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final String _lowerBoundary;
        final String _upperBoundary;
        final boolean _includeLowerBoundary;
        final boolean _includeUpperBoundary;

        StringRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate) {
            this._lowerBoundary = rangePredicate.getLowerBoundary();
            this._upperBoundary = rangePredicate.getUpperBoundary();
            this._includeLowerBoundary = rangePredicate.includeLowerBoundary();
            this._includeUpperBoundary = rangePredicate.includeUpperBoundary();
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.RANGE;
        }

        @Override
        public boolean applySV(String value) {
            boolean result = true;
            if (!this._lowerBoundary.equals("*")) {
                if (this._includeLowerBoundary) {
                    result = this._lowerBoundary.compareTo(value) <= 0;
                } else {
                    boolean bl = result = this._lowerBoundary.compareTo(value) < 0;
                }
            }
            if (!this._upperBoundary.equals("*")) {
                result = this._includeUpperBoundary ? (result &= this._upperBoundary.compareTo(value) >= 0) : (result &= this._upperBoundary.compareTo(value) > 0);
            }
            return result;
        }
    }

    private static final class DoubleRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final double _lowerBoundary;
        final double _upperBoundary;
        final boolean _includeLowerBoundary;
        final boolean _includeUpperBoundary;

        DoubleRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate) {
            this._includeLowerBoundary = rangePredicate.includeLowerBoundary();
            this._includeUpperBoundary = rangePredicate.includeUpperBoundary();
            String lowerBoundary = rangePredicate.getLowerBoundary();
            String upperBoundary = rangePredicate.getUpperBoundary();
            this._lowerBoundary = lowerBoundary.equals("*") ? -2.147483648E9 : Double.parseDouble(lowerBoundary);
            this._upperBoundary = upperBoundary.equals("*") ? 2.147483647E9 : Double.parseDouble(upperBoundary);
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.RANGE;
        }

        @Override
        public boolean applySV(double value) {
            boolean result;
            if (this._includeLowerBoundary) {
                result = this._lowerBoundary <= value;
            } else {
                boolean bl = result = this._lowerBoundary < value;
            }
            result = this._includeUpperBoundary ? (result &= this._upperBoundary >= value) : (result &= this._upperBoundary > value);
            return result;
        }
    }

    private static final class FloatRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final float _lowerBoundary;
        final float _upperBoundary;
        final boolean _includeLowerBoundary;
        final boolean _includeUpperBoundary;

        FloatRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate) {
            this._includeLowerBoundary = rangePredicate.includeLowerBoundary();
            this._includeUpperBoundary = rangePredicate.includeUpperBoundary();
            String lowerBoundary = rangePredicate.getLowerBoundary();
            String upperBoundary = rangePredicate.getUpperBoundary();
            this._lowerBoundary = lowerBoundary.equals("*") ? -2.1474836E9f : Float.parseFloat(lowerBoundary);
            this._upperBoundary = upperBoundary.equals("*") ? 2.1474836E9f : Float.parseFloat(upperBoundary);
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.RANGE;
        }

        @Override
        public boolean applySV(float value) {
            boolean result;
            if (this._includeLowerBoundary) {
                result = this._lowerBoundary <= value;
            } else {
                boolean bl = result = this._lowerBoundary < value;
            }
            result = this._includeUpperBoundary ? (result &= this._upperBoundary >= value) : (result &= this._upperBoundary > value);
            return result;
        }
    }

    private static final class LongRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final long _lowerBoundary;
        final long _upperBoundary;
        final boolean _includeLowerBoundary;
        final boolean _includeUpperBoundary;

        LongRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate) {
            this._includeLowerBoundary = rangePredicate.includeLowerBoundary();
            this._includeUpperBoundary = rangePredicate.includeUpperBoundary();
            String lowerBoundary = rangePredicate.getLowerBoundary();
            String upperBoundary = rangePredicate.getUpperBoundary();
            this._lowerBoundary = lowerBoundary.equals("*") ? Integer.MIN_VALUE : Long.parseLong(lowerBoundary);
            this._upperBoundary = upperBoundary.equals("*") ? Integer.MAX_VALUE : Long.parseLong(upperBoundary);
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.RANGE;
        }

        @Override
        public boolean applySV(long value) {
            boolean result;
            if (this._includeLowerBoundary) {
                result = this._lowerBoundary <= value;
            } else {
                boolean bl = result = this._lowerBoundary < value;
            }
            result = this._includeUpperBoundary ? (result &= this._upperBoundary >= value) : (result &= this._upperBoundary > value);
            return result;
        }
    }

    private static final class IntRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final int _lowerBoundary;
        final int _upperBoundary;
        final boolean _includeLowerBoundary;
        final boolean _includeUpperBoundary;

        IntRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate) {
            this._includeLowerBoundary = rangePredicate.includeLowerBoundary();
            this._includeUpperBoundary = rangePredicate.includeUpperBoundary();
            String lowerBoundary = rangePredicate.getLowerBoundary();
            String upperBoundary = rangePredicate.getUpperBoundary();
            this._lowerBoundary = lowerBoundary.equals("*") ? Integer.MIN_VALUE : Integer.parseInt(lowerBoundary);
            this._upperBoundary = upperBoundary.equals("*") ? Integer.MAX_VALUE : Integer.parseInt(upperBoundary);
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.RANGE;
        }

        @Override
        public boolean applySV(int value) {
            boolean result;
            if (this._includeLowerBoundary) {
                result = this._lowerBoundary <= value;
            } else {
                boolean bl = result = this._lowerBoundary < value;
            }
            result = this._includeUpperBoundary ? (result &= this._upperBoundary >= value) : (result &= this._upperBoundary > value);
            return result;
        }
    }

    private static final class RealtimeDictionaryBasedRangePredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final IntSet _matchingDictIdSet = new IntOpenHashSet();
        final int _numMatchingDictIds;
        int[] _matchingDictIds;

        RealtimeDictionaryBasedRangePredicateEvaluator(RangePredicate rangePredicate, MutableDictionary dictionary) {
            int dictionarySize = dictionary.length();
            if (dictionarySize == 0) {
                this._numMatchingDictIds = 0;
                this._alwaysFalse = true;
                return;
            }
            String lowerBoundary = rangePredicate.getLowerBoundary();
            String upperBoundary = rangePredicate.getUpperBoundary();
            boolean includeLowerBoundary = rangePredicate.includeLowerBoundary();
            boolean includeUpperBoundary = rangePredicate.includeUpperBoundary();
            if (lowerBoundary.equals("*")) {
                lowerBoundary = dictionary.getMinVal().toString();
            }
            if (upperBoundary.equals("*")) {
                upperBoundary = dictionary.getMaxVal().toString();
            }
            for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                if (!dictionary.inRange(lowerBoundary, upperBoundary, dictId, includeLowerBoundary, includeUpperBoundary)) continue;
                this._matchingDictIdSet.add(dictId);
            }
            this._numMatchingDictIds = this._matchingDictIdSet.size();
            if (this._numMatchingDictIds == 0) {
                this._alwaysFalse = true;
            } else if (dictionarySize == this._numMatchingDictIds) {
                this._alwaysTrue = true;
            }
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.RANGE;
        }

        @Override
        public boolean applySV(int dictId) {
            return this._matchingDictIdSet.contains(dictId);
        }

        @Override
        public int getNumMatchingDictIds() {
            return this._numMatchingDictIds;
        }

        @Override
        public int[] getMatchingDictIds() {
            if (this._matchingDictIds == null) {
                this._matchingDictIds = this._matchingDictIdSet.toIntArray();
            }
            return this._matchingDictIds;
        }
    }

    private static final class OfflineDictionaryBasedRangePredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final int _startDictId;
        final int _endDictId;
        final int _numMatchingDictIds;
        int[] _matchingDictIds;

        OfflineDictionaryBasedRangePredicateEvaluator(RangePredicate rangePredicate, ImmutableDictionaryReader dictionary) {
            int insertionIndex;
            String lowerBoundary = rangePredicate.getLowerBoundary();
            String upperBoundary = rangePredicate.getUpperBoundary();
            boolean includeLowerBoundary = rangePredicate.includeLowerBoundary();
            boolean includeUpperBoundary = rangePredicate.includeUpperBoundary();
            this._startDictId = lowerBoundary.equals("*") ? 0 : ((insertionIndex = dictionary.insertionIndexOf(lowerBoundary)) < 0 ? -(insertionIndex + 1) : (includeLowerBoundary ? insertionIndex : insertionIndex + 1));
            this._endDictId = upperBoundary.equals("*") ? dictionary.length() : ((insertionIndex = dictionary.insertionIndexOf(upperBoundary)) < 0 ? -(insertionIndex + 1) : (includeUpperBoundary ? insertionIndex + 1 : insertionIndex));
            this._numMatchingDictIds = this._endDictId - this._startDictId;
            if (this._numMatchingDictIds <= 0) {
                this._alwaysFalse = true;
            } else if (dictionary.length() == this._numMatchingDictIds) {
                this._alwaysTrue = true;
            }
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.RANGE;
        }

        @Override
        public boolean applySV(int dictId) {
            return this._startDictId <= dictId && this._endDictId > dictId;
        }

        @Override
        public int getNumMatchingDictIds() {
            return this._numMatchingDictIds;
        }

        @Override
        public int[] getMatchingDictIds() {
            if (this._matchingDictIds == null) {
                if (this._numMatchingDictIds <= 0) {
                    this._matchingDictIds = new int[0];
                } else {
                    this._matchingDictIds = new int[this._numMatchingDictIds];
                    for (int i = 0; i < this._numMatchingDictIds; ++i) {
                        this._matchingDictIds[i] = this._startDictId + i;
                    }
                }
            }
            return this._matchingDictIds;
        }
    }
}

