/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.regex.Pattern;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Predicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.RegexpLikePredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.common.data.FieldSpec;

public class RegexpLikePredicateEvaluatorFactory {
    private static final int PATTERN_FLAG = 66;

    private RegexpLikePredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(RegexpLikePredicate regexpLikePredicate, Dictionary dictionary) {
        return new DictionaryBasedRegexpLikePredicateEvaluator(regexpLikePredicate, dictionary);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(RegexpLikePredicate regexpLikePredicate, FieldSpec.DataType dataType) {
        Preconditions.checkArgument(dataType == FieldSpec.DataType.STRING, "Unsupported data type: " + (Object)((Object)dataType));
        return new RawValueBasedRegexpLikePredicateEvaluator(regexpLikePredicate);
    }

    private static final class RawValueBasedRegexpLikePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final Pattern _pattern;

        public RawValueBasedRegexpLikePredicateEvaluator(RegexpLikePredicate regexpLikePredicate) {
            this._pattern = Pattern.compile(regexpLikePredicate.getRegex(), 66);
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.REGEXP_LIKE;
        }

        @Override
        public boolean applySV(String value) {
            return this._pattern.matcher(value).find();
        }
    }

    private static final class DictionaryBasedRegexpLikePredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final Pattern _pattern;
        final Dictionary _dictionary;
        int[] _matchingDictIds;

        public DictionaryBasedRegexpLikePredicateEvaluator(RegexpLikePredicate regexpLikePredicate, Dictionary dictionary) {
            this._pattern = Pattern.compile(regexpLikePredicate.getRegex(), 66);
            this._dictionary = dictionary;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.REGEXP_LIKE;
        }

        @Override
        public boolean applySV(int dictId) {
            return this._pattern.matcher(this._dictionary.getStringValue(dictId)).find();
        }

        @Override
        public int[] getMatchingDictIds() {
            if (this._matchingDictIds == null) {
                IntArrayList matchingDictIds = new IntArrayList();
                int dictionarySize = this._dictionary.length();
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    if (!this.applySV(dictId)) continue;
                    matchingDictIds.add(dictId);
                }
                this._matchingDictIds = matchingDictIds.toIntArray();
            }
            return this._matchingDictIds;
        }
    }
}

