/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.query;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.DefaultGroupByExecutor;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.executor.StarTreeGroupByExecutor;
import org.apache.pinot.common.request.GroupBy;

public class AggregationGroupByOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "AggregationGroupByOperator";
    private final AggregationFunctionContext[] _functionContexts;
    private final GroupBy _groupBy;
    private final int _maxInitialResultHolderCapacity;
    private final int _numGroupsLimit;
    private final TransformOperator _transformOperator;
    private final long _numTotalRawDocs;
    private final boolean _useStarTree;
    private ExecutionStatistics _executionStatistics;

    public AggregationGroupByOperator(@Nonnull AggregationFunctionContext[] functionContexts, @Nonnull GroupBy groupBy, int maxInitialResultHolderCapacity, int numGroupsLimit, @Nonnull TransformOperator transformOperator, long numTotalRawDocs, boolean useStarTree) {
        this._functionContexts = functionContexts;
        this._groupBy = groupBy;
        this._maxInitialResultHolderCapacity = maxInitialResultHolderCapacity;
        this._numGroupsLimit = numGroupsLimit;
        this._transformOperator = transformOperator;
        this._numTotalRawDocs = numTotalRawDocs;
        this._useStarTree = useStarTree;
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        TransformBlock transformBlock;
        int numDocsScanned = 0;
        DefaultGroupByExecutor groupByExecutor = this._useStarTree ? new StarTreeGroupByExecutor(this._functionContexts, this._groupBy, this._maxInitialResultHolderCapacity, this._numGroupsLimit, this._transformOperator) : new DefaultGroupByExecutor(this._functionContexts, this._groupBy, this._maxInitialResultHolderCapacity, this._numGroupsLimit, this._transformOperator);
        while ((transformBlock = (TransformBlock)this._transformOperator.nextBlock()) != null) {
            numDocsScanned += transformBlock.getNumDocs();
            groupByExecutor.process(transformBlock);
        }
        AggregationGroupByResult groupByResult = groupByExecutor.getResult();
        long numEntriesScannedInFilter = this._transformOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = numDocsScanned * this._transformOperator.getNumColumnsProjected();
        this._executionStatistics = new ExecutionStatistics(numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, this._numTotalRawDocs);
        return new IntermediateResultsBlock(this._functionContexts, groupByResult);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return this._executionStatistics;
    }
}

