/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.query;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.DefaultAggregationExecutor;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.executor.StarTreeAggregationExecutor;

public class AggregationOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "AggregationOperator";
    private final AggregationFunctionContext[] _functionContexts;
    private final TransformOperator _transformOperator;
    private final long _numTotalRawDocs;
    private final boolean _useStarTree;
    private ExecutionStatistics _executionStatistics;

    public AggregationOperator(@Nonnull AggregationFunctionContext[] functionContexts, @Nonnull TransformOperator transformOperator, long numTotalRawDocs, boolean useStarTree) {
        this._functionContexts = functionContexts;
        this._transformOperator = transformOperator;
        this._numTotalRawDocs = numTotalRawDocs;
        this._useStarTree = useStarTree;
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        TransformBlock transformBlock;
        int numDocsScanned = 0;
        DefaultAggregationExecutor aggregationExecutor = this._useStarTree ? new StarTreeAggregationExecutor(this._functionContexts) : new DefaultAggregationExecutor(this._functionContexts);
        while ((transformBlock = (TransformBlock)this._transformOperator.nextBlock()) != null) {
            numDocsScanned += transformBlock.getNumDocs();
            aggregationExecutor.aggregate(transformBlock);
        }
        List<Object> aggregationResult = aggregationExecutor.getResult();
        long numEntriesScannedInFilter = this._transformOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = numDocsScanned * this._transformOperator.getNumColumnsProjected();
        this._executionStatistics = new ExecutionStatistics(numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, this._numTotalRawDocs);
        return new IntermediateResultsBlock(this._functionContexts, aggregationResult, false);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return this._executionStatistics;
    }
}

