/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.transform;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function.TransformFunctionFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.common.request.transform.TransformExpressionTree;

public class TransformOperator
extends BaseOperator<TransformBlock> {
    private static final String OPERATOR_NAME = "TransformOperator";
    private final ProjectionOperator _projectionOperator;
    private final Map<String, DataSource> _dataSourceMap;
    private final Map<TransformExpressionTree, TransformFunction> _transformFunctionMap = new HashMap<TransformExpressionTree, TransformFunction>();

    public TransformOperator(@Nonnull ProjectionOperator projectionOperator, @Nonnull Set<TransformExpressionTree> expressions) {
        this._projectionOperator = projectionOperator;
        this._dataSourceMap = projectionOperator.getDataSourceMap();
        for (TransformExpressionTree expression : expressions) {
            TransformFunction transformFunction = TransformFunctionFactory.get(expression, this._dataSourceMap);
            this._transformFunctionMap.put(expression, transformFunction);
        }
    }

    public int getNumColumnsProjected() {
        return this._dataSourceMap.size();
    }

    public TransformResultMetadata getResultMetadata(@Nonnull TransformExpressionTree expression) {
        return this._transformFunctionMap.get(expression).getResultMetadata();
    }

    public Dictionary getDictionary(@Nonnull TransformExpressionTree expression) {
        return this._transformFunctionMap.get(expression).getDictionary();
    }

    @Override
    protected TransformBlock getNextBlock() {
        ProjectionBlock projectionBlock = (ProjectionBlock)this._projectionOperator.nextBlock();
        if (projectionBlock == null) {
            return null;
        }
        return new TransformBlock(projectionBlock, this._transformFunctionMap);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return this._projectionOperator.getExecutionStatistics();
    }
}

