/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;

public class IdentifierTransformFunction
implements TransformFunction {
    private final String _columnName;
    private final DataSource _dataSource;
    private final TransformResultMetadata _resultMetadata;

    public IdentifierTransformFunction(@Nonnull String columnName, @Nonnull DataSource dataSource) {
        this._columnName = columnName;
        this._dataSource = dataSource;
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        this._resultMetadata = new TransformResultMetadata(dataSourceMetadata.getDataType(), dataSourceMetadata.isSingleValue(), dataSourceMetadata.hasDictionary());
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void init(@Nonnull List<TransformFunction> arguments, @Nonnull Map<String, DataSource> dataSourceMap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public Dictionary getDictionary() {
        return this._dataSource.getDictionary();
    }

    @Override
    public int[] transformToDictIdsSV(@Nonnull ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getDictionaryIdsSV();
    }

    @Override
    public int[][] transformToDictIdsMV(@Nonnull ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getDictionaryIdsMV();
    }

    @Override
    public int[] transformToIntValuesSV(@Nonnull ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getIntValuesSV();
    }

    @Override
    public long[] transformToLongValuesSV(@Nonnull ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getLongValuesSV();
    }

    @Override
    public float[] transformToFloatValuesSV(@Nonnull ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getFloatValuesSV();
    }

    @Override
    public double[] transformToDoubleValuesSV(@Nonnull ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getDoubleValuesSV();
    }

    @Override
    public String[] transformToStringValuesSV(@Nonnull ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getStringValuesSV();
    }

    @Override
    public int[][] transformToIntValuesMV(@Nonnull ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getIntValuesMV();
    }

    @Override
    public long[][] transformToLongValuesMV(@Nonnull ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getLongValuesMV();
    }

    @Override
    public float[][] transformToFloatValuesMV(@Nonnull ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getFloatValuesMV();
    }

    @Override
    public double[][] transformToDoubleValuesMV(@Nonnull ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getDoubleValuesMV();
    }

    @Override
    public String[][] transformToStringValuesMV(@Nonnull ProjectionBlock projectionBlock) {
        return projectionBlock.getBlockValueSet(this._columnName).getStringValuesMV();
    }
}

