/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.DocIdSetPlanNode;

public class MultiplicationTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "mult";
    private double _literalProduct = 1.0;
    private List<TransformFunction> _transformFunctions = new ArrayList<TransformFunction>();
    private double[] _products;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(@Nonnull List<TransformFunction> arguments, @Nonnull Map<String, DataSource> dataSourceMap) {
        if (arguments.size() < 2) {
            throw new IllegalArgumentException("At least 2 arguments are required for MULT transform function");
        }
        for (TransformFunction argument : arguments) {
            if (argument instanceof LiteralTransformFunction) {
                this._literalProduct *= Double.parseDouble(((LiteralTransformFunction)argument).getLiteral());
                continue;
            }
            if (!argument.getResultMetadata().isSingleValue()) {
                throw new IllegalArgumentException("All the arguments of MULT transform function must be single-valued");
            }
            this._transformFunctions.add(argument);
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return DOUBLE_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public double[] transformToDoubleValuesSV(@Nonnull ProjectionBlock projectionBlock) {
        if (this._products == null) {
            this._products = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        Arrays.fill(this._products, 0, length, this._literalProduct);
        block7: for (TransformFunction transformFunction : this._transformFunctions) {
            switch (transformFunction.getResultMetadata().getDataType()) {
                case INT: {
                    int[] intValues = transformFunction.transformToIntValuesSV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        int n = i;
                        this._products[n] = this._products[n] * (double)intValues[i];
                    }
                    continue block7;
                }
                case LONG: {
                    long[] longValues = transformFunction.transformToLongValuesSV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        int n = i;
                        this._products[n] = this._products[n] * (double)longValues[i];
                    }
                    continue block7;
                }
                case FLOAT: {
                    float[] floatValues = transformFunction.transformToFloatValuesSV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        int n = i;
                        this._products[n] = this._products[n] * (double)floatValues[i];
                    }
                    continue block7;
                }
                case DOUBLE: {
                    double[] doubleValues = transformFunction.transformToDoubleValuesSV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        int n = i;
                        this._products[n] = this._products[n] * doubleValues[i];
                    }
                    continue block7;
                }
                case STRING: {
                    String[] stringValues = transformFunction.transformToStringValuesSV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        int n = i;
                        this._products[n] = this._products[n] * Double.parseDouble(stringValues[i]);
                    }
                    continue block7;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return this._products;
    }
}

