/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.periodictask;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.$internal.org.apache.pinot.core.periodictask.PeriodicTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BasePeriodicTask
implements PeriodicTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePeriodicTask.class);
    private static final long MAX_PERIODIC_TASK_STOP_TIME_MILLIS = 30000L;
    protected final String _taskName;
    protected final long _intervalInSeconds;
    protected final long _initialDelayInSeconds;
    private volatile boolean _started;
    private volatile boolean _running;

    public BasePeriodicTask(String taskName, long runFrequencyInSeconds, long initialDelayInSeconds) {
        this._taskName = taskName;
        this._intervalInSeconds = runFrequencyInSeconds;
        this._initialDelayInSeconds = initialDelayInSeconds;
    }

    @Override
    public String getTaskName() {
        return this._taskName;
    }

    @Override
    public long getIntervalInSeconds() {
        return this._intervalInSeconds;
    }

    @Override
    public long getInitialDelayInSeconds() {
        return this._initialDelayInSeconds;
    }

    public final boolean isStarted() {
        return this._started;
    }

    public final boolean isRunning() {
        return this._running;
    }

    @Override
    public final synchronized void start() {
        if (this._started) {
            LOGGER.warn("Task: {} is already started", (Object)this._taskName);
            return;
        }
        this._started = true;
        try {
            this.setUpTask();
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while setting up task: {}", (Object)this._taskName, (Object)e);
        }
    }

    protected void setUpTask() {
    }

    @Override
    public final void run() {
        this._running = true;
        if (this._started) {
            long startTime = System.currentTimeMillis();
            LOGGER.info("Start running task: {}", (Object)this._taskName);
            try {
                this.runTask();
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while running task: {}", (Object)this._taskName, (Object)e);
            }
            LOGGER.info("Finish running task: {} in {}ms", (Object)this._taskName, (Object)(System.currentTimeMillis() - startTime));
        } else {
            LOGGER.warn("Task: {} is skipped because it is not started or already stopped", (Object)this._taskName);
        }
        this._running = false;
    }

    protected abstract void runTask();

    @Override
    public final synchronized void stop() {
        if (!this._started) {
            LOGGER.warn("Task: {} is not started", (Object)this._taskName);
            return;
        }
        this._started = false;
        if (this._running) {
            long sleepTimeMs;
            long remainingTimeMs;
            long startTimeMs = System.currentTimeMillis();
            LOGGER.info("Task: {} is running, wait for at most {}ms for it to finish", (Object)this._taskName, (Object)remainingTimeMs);
            for (remainingTimeMs = 30000L; this._running && remainingTimeMs > 0L; remainingTimeMs -= sleepTimeMs) {
                sleepTimeMs = Long.min(remainingTimeMs, 1000L);
                try {
                    Thread.sleep(sleepTimeMs);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.error("Caught InterruptedException while waiting for task: {} to finish", (Object)this._taskName);
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            long waitTimeMs = System.currentTimeMillis() - startTimeMs;
            if (this._running) {
                LOGGER.warn("Task: {} is not finished in {}ms", (Object)waitTimeMs);
            } else {
                LOGGER.info("Task: {} is finished in {}ms", (Object)waitTimeMs);
            }
        }
        try {
            this.cleanUpTask();
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while cleaning up task: {}", (Object)this._taskName, (Object)e);
        }
    }

    protected void cleanUpTask() {
    }

    public String toString() {
        return String.format("Task: %s, Interval: %ds, Initial Delay: %ds", this._taskName, this._intervalInSeconds, this._initialDelayInSeconds);
    }
}

