/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.plan;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.query.AggregationOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.TransformPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.StarTreeUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.plan.StarTreeTransformPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.StarTreeV2;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationPlanNode
implements PlanNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregationPlanNode.class);
    private final IndexSegment _indexSegment;
    private final List<AggregationInfo> _aggregationInfos;
    private final AggregationFunctionContext[] _functionContexts;
    private final TransformPlanNode _transformPlanNode;
    private final StarTreeTransformPlanNode _starTreeTransformPlanNode;

    public AggregationPlanNode(@Nonnull IndexSegment indexSegment, @Nonnull BrokerRequest brokerRequest) {
        this._indexSegment = indexSegment;
        this._aggregationInfos = brokerRequest.getAggregationsInfo();
        this._functionContexts = AggregationFunctionUtils.getAggregationFunctionContexts(this._aggregationInfos, indexSegment.getSegmentMetadata());
        List<StarTreeV2> starTrees = indexSegment.getStarTrees();
        if (starTrees != null && !StarTreeUtils.isStarTreeDisabled(brokerRequest)) {
            HashSet<AggregationFunctionColumnPair> aggregationFunctionColumnPairs = new HashSet<AggregationFunctionColumnPair>();
            for (AggregationInfo aggregationInfo : this._aggregationInfos) {
                aggregationFunctionColumnPairs.add(AggregationFunctionUtils.getFunctionColumnPair(aggregationInfo));
            }
            FilterQueryTree rootFilterNode = RequestUtils.generateFilterQueryTree(brokerRequest);
            for (StarTreeV2 starTreeV2 : starTrees) {
                if (!StarTreeUtils.isFitForStarTree(starTreeV2.getMetadata(), aggregationFunctionColumnPairs, null, rootFilterNode)) continue;
                this._transformPlanNode = null;
                this._starTreeTransformPlanNode = new StarTreeTransformPlanNode(starTreeV2, aggregationFunctionColumnPairs, null, rootFilterNode, brokerRequest.getDebugOptions());
                return;
            }
        }
        this._transformPlanNode = new TransformPlanNode(this._indexSegment, brokerRequest);
        this._starTreeTransformPlanNode = null;
    }

    @Override
    public AggregationOperator run() {
        int numTotalRawDocs = this._indexSegment.getSegmentMetadata().getTotalRawDocs();
        if (this._transformPlanNode != null) {
            return new AggregationOperator(this._functionContexts, this._transformPlanNode.run(), numTotalRawDocs, false);
        }
        return new AggregationOperator(this._functionContexts, this._starTreeTransformPlanNode.run(), numTotalRawDocs, true);
    }

    @Override
    public void showTree(String prefix) {
        LOGGER.debug(prefix + "Aggregation Plan Node:");
        LOGGER.debug(prefix + "Operator: AggregationOperator");
        LOGGER.debug(prefix + "Argument 0: IndexSegment - " + this._indexSegment.getSegmentName());
        LOGGER.debug(prefix + "Argument 1: Aggregations - " + this._aggregationInfos);
        if (this._transformPlanNode != null) {
            LOGGER.debug(prefix + "Argument 2: TransformPlanNode -");
            this._transformPlanNode.showTree(prefix + "    ");
        } else {
            LOGGER.debug(prefix + "Argument 2: StarTreeTransformPlanNode -");
            this._starTreeTransformPlanNode.showTree(prefix + "    ");
        }
    }
}

