/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Operator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.CombineGroupByOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.CombineOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.query.exception.BadQueryRequestException;
import org.apache.pinot.$internal.org.apache.pinot.core.util.trace.TraceCallable;
import org.apache.pinot.common.request.BrokerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinePlanNode
implements PlanNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(CombinePlanNode.class);
    private static final int MAX_PLAN_THREADS = Math.min(10, (int)((double)Runtime.getRuntime().availableProcessors() * 0.5));
    private static final int MIN_TASKS_PER_THREAD = 10;
    private static final int TIME_OUT_IN_MILLISECONDS_FOR_PARALLEL_RUN = 10000;
    private final List<PlanNode> _planNodes;
    private final BrokerRequest _brokerRequest;
    private final ExecutorService _executorService;
    private final long _timeOutMs;
    private final int _numGroupsLimit;

    public CombinePlanNode(List<PlanNode> planNodes, BrokerRequest brokerRequest, ExecutorService executorService, long timeOutMs, int numGroupsLimit) {
        this._planNodes = planNodes;
        this._brokerRequest = brokerRequest;
        this._executorService = executorService;
        this._timeOutMs = timeOutMs;
        this._numGroupsLimit = numGroupsLimit;
    }

    @Override
    public Operator run() {
        final int numPlanNodes = this._planNodes.size();
        ArrayList<Operator> operators = new ArrayList<Operator>(numPlanNodes);
        if (numPlanNodes <= 10) {
            for (PlanNode planNode : this._planNodes) {
                operators.add(planNode.run());
            }
        } else {
            long endTime = System.currentTimeMillis() + 10000L;
            int threads = Math.min(numPlanNodes / 10 + (numPlanNodes % 10 == 0 ? 0 : 1), MAX_PLAN_THREADS);
            final int opsPerThread = Math.max(numPlanNodes / threads + (numPlanNodes % threads == 0 ? 0 : 1), 10);
            Future[] futures = new Future[threads];
            for (int i = 0; i < threads; ++i) {
                final int index = i;
                futures[i] = this._executorService.submit(new TraceCallable<List<Operator>>(){

                    @Override
                    public List<Operator> callJob() throws Exception {
                        ArrayList<Operator> operators = new ArrayList<Operator>();
                        int start = index * opsPerThread;
                        int limit = Math.min(opsPerThread, numPlanNodes - start);
                        for (int count = start; count < start + limit; ++count) {
                            operators.add(((PlanNode)CombinePlanNode.this._planNodes.get(count)).run());
                        }
                        return operators;
                    }
                });
            }
            try {
                for (Future future : futures) {
                    List ops = (List)future.get(endTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                    operators.addAll(ops);
                }
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof BadQueryRequestException) {
                    throw (BadQueryRequestException)cause;
                }
                throw new RuntimeException("Caught exception while running CombinePlanNode.", e);
            }
            finally {
                for (Future future : futures) {
                    if (future.isDone()) continue;
                    future.cancel(true);
                }
            }
        }
        if (this._brokerRequest.isSetAggregationsInfo() && this._brokerRequest.getGroupBy() != null) {
            return new CombineGroupByOperator(operators, this._brokerRequest, this._executorService, this._timeOutMs, this._numGroupsLimit);
        }
        return new CombineOperator(operators, this._executorService, this._timeOutMs, this._brokerRequest);
    }

    @Override
    public void showTree(String prefix) {
        LOGGER.debug(prefix + "Instance Level Inter-Segments Combine Plan Node:");
        LOGGER.debug(prefix + "Operator: CombineOperator/CombineGroupByOperator");
        LOGGER.debug(prefix + "Argument 0: BrokerRequest - " + this._brokerRequest);
        int i = 1;
        for (PlanNode planNode : this._planNodes) {
            LOGGER.debug(prefix + "Argument " + i++ + ":");
            planNode.showTree(prefix + "    ");
        }
    }
}

