/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.plan;

import java.util.HashMap;
import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Operator;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.query.MetadataBasedAggregationOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.segment.SegmentMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataBasedAggregationPlanNode
implements PlanNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataBasedAggregationPlanNode.class);
    private final IndexSegment _indexSegment;
    private final List<AggregationInfo> _aggregationInfos;

    public MetadataBasedAggregationPlanNode(IndexSegment indexSegment, List<AggregationInfo> aggregationInfos) {
        this._indexSegment = indexSegment;
        this._aggregationInfos = aggregationInfos;
    }

    @Override
    public Operator run() {
        SegmentMetadata segmentMetadata = this._indexSegment.getSegmentMetadata();
        AggregationFunctionContext[] aggregationFunctionContexts = AggregationFunctionUtils.getAggregationFunctionContexts(this._aggregationInfos, segmentMetadata);
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        for (AggregationFunctionContext aggregationFunctionContext : aggregationFunctionContexts) {
            String column;
            if (aggregationFunctionContext.getAggregationFunction().getType() == AggregationFunctionType.COUNT || dataSourceMap.containsKey(column = aggregationFunctionContext.getColumn())) continue;
            dataSourceMap.put(column, this._indexSegment.getDataSource(column));
        }
        return new MetadataBasedAggregationOperator(aggregationFunctionContexts, segmentMetadata, dataSourceMap);
    }

    @Override
    public void showTree(String prefix) {
        LOGGER.debug(prefix + "Segment Level Inner-Segment Plan Node:");
        LOGGER.debug(prefix + "Operator: MetadataBasedAggregationOperator");
        LOGGER.debug(prefix + "Argument 0: IndexSegment - " + this._indexSegment.getSegmentName());
        LOGGER.debug(prefix + "Argument 1: Aggregations - " + this._aggregationInfos);
    }
}

