/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.plan.maker;

import java.util.List;
import java.util.Objects;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.common.data.MetricFieldSpec;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.segment.SegmentMetadata;

public class BrokerRequestPreProcessor {
    private BrokerRequestPreProcessor() {
    }

    public static void preProcess(List<IndexSegment> indexSegments, BrokerRequest brokerRequest) {
        if (brokerRequest.isSetAggregationsInfo()) {
            List<AggregationInfo> aggregationsInfo = brokerRequest.getAggregationsInfo();
            BrokerRequestPreProcessor.rewriteFastHllColumnName(indexSegments, aggregationsInfo);
        }
    }

    private static void rewriteFastHllColumnName(List<IndexSegment> indexSegments, List<AggregationInfo> aggregationsInfo) {
        for (AggregationInfo aggregationInfo : aggregationsInfo) {
            if (!aggregationInfo.getAggregationType().equalsIgnoreCase("fasthll")) continue;
            String column = AggregationFunctionUtils.getColumn(aggregationInfo);
            boolean isFirstSegment = true;
            String firstSegmentName = null;
            String hllDerivedColumn = null;
            for (IndexSegment indexSegment : indexSegments) {
                SegmentMetadata segmentMetadata = indexSegment.getSegmentMetadata();
                if (isFirstSegment) {
                    isFirstSegment = false;
                    firstSegmentName = segmentMetadata.getName();
                    hllDerivedColumn = segmentMetadata.getDerivedColumn(column, MetricFieldSpec.DerivedMetricType.HLL);
                    if (hllDerivedColumn == null) continue;
                    aggregationInfo.putToAggregationParams("column", hllDerivedColumn);
                    continue;
                }
                String hllDerivedColumnToCheck = segmentMetadata.getDerivedColumn(column, MetricFieldSpec.DerivedMetricType.HLL);
                if (Objects.equals(hllDerivedColumn, hllDerivedColumnToCheck)) continue;
                throw new RuntimeException("Found inconsistency HLL derived column name. In segment " + firstSegmentName + ": " + hllDerivedColumn + "; In segment " + segmentMetadata.getName() + ": " + hllDerivedColumnToCheck);
            }
        }
    }
}

