/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.plan.maker;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.pinot.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.SegmentDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.AggregationGroupByPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.AggregationPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.CombinePlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.DictionaryBasedAggregationPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.GlobalPlanImplV0;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.InstanceResponsePlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.MetadataBasedAggregationPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.Plan;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.SelectionPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.maker.BrokerRequestPreProcessor;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.maker.PlanMaker;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.query.config.QueryExecutorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.transform.TransformExpressionTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstancePlanMakerImplV2
implements PlanMaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstancePlanMakerImplV2.class);
    public static final String MAX_INITIAL_RESULT_HOLDER_CAPACITY_KEY = "max.init.group.holder.capacity";
    public static final int DEFAULT_MAX_INITIAL_RESULT_HOLDER_CAPACITY = 10000;
    public static final String NUM_GROUPS_LIMIT = "num.groups.limit";
    public static final int DEFAULT_NUM_GROUPS_LIMIT = 100000;
    private final int _maxInitialResultHolderCapacity;
    private final int _numGroupsLimit;

    @VisibleForTesting
    public InstancePlanMakerImplV2() {
        this._maxInitialResultHolderCapacity = 10000;
        this._numGroupsLimit = 100000;
    }

    @VisibleForTesting
    public InstancePlanMakerImplV2(int maxInitialResultHolderCapacity, int numGroupsLimit) {
        this._maxInitialResultHolderCapacity = maxInitialResultHolderCapacity;
        this._numGroupsLimit = numGroupsLimit;
    }

    public InstancePlanMakerImplV2(QueryExecutorConfig queryExecutorConfig) {
        this._maxInitialResultHolderCapacity = queryExecutorConfig.getConfig().getInt(MAX_INITIAL_RESULT_HOLDER_CAPACITY_KEY, 10000);
        this._numGroupsLimit = queryExecutorConfig.getConfig().getInt(NUM_GROUPS_LIMIT, 100000);
        Preconditions.checkState(this._maxInitialResultHolderCapacity <= this._numGroupsLimit, "Invalid configuration: maxInitialResultHolderCapacity: %d must be smaller or equal to numGroupsLimit: %d", this._maxInitialResultHolderCapacity, this._numGroupsLimit);
        LOGGER.info("Initializing plan maker with maxInitialResultHolderCapacity: {}, numGroupsLimit: {}", (Object)this._maxInitialResultHolderCapacity, (Object)this._numGroupsLimit);
    }

    @Override
    public PlanNode makeInnerSegmentPlan(IndexSegment indexSegment, BrokerRequest brokerRequest) {
        if (brokerRequest.isSetAggregationsInfo()) {
            if (brokerRequest.isSetGroupBy()) {
                return new AggregationGroupByPlanNode(indexSegment, brokerRequest, this._maxInitialResultHolderCapacity, this._numGroupsLimit);
            }
            if (InstancePlanMakerImplV2.isFitForMetadataBasedPlan(brokerRequest, indexSegment)) {
                return new MetadataBasedAggregationPlanNode(indexSegment, brokerRequest.getAggregationsInfo());
            }
            if (InstancePlanMakerImplV2.isFitForDictionaryBasedPlan(brokerRequest, indexSegment)) {
                return new DictionaryBasedAggregationPlanNode(indexSegment, brokerRequest.getAggregationsInfo());
            }
            return new AggregationPlanNode(indexSegment, brokerRequest);
        }
        if (brokerRequest.isSetSelections()) {
            return new SelectionPlanNode(indexSegment, brokerRequest);
        }
        throw new UnsupportedOperationException("The query contains no aggregation or selection.");
    }

    @Override
    public Plan makeInterSegmentPlan(List<SegmentDataManager> segmentDataManagers, BrokerRequest brokerRequest, ExecutorService executorService, long timeOutMs) {
        ArrayList<IndexSegment> indexSegments = new ArrayList<IndexSegment>(segmentDataManagers.size());
        for (SegmentDataManager segmentDataManager : segmentDataManagers) {
            indexSegments.add(segmentDataManager.getSegment());
        }
        BrokerRequestPreProcessor.preProcess(indexSegments, brokerRequest);
        ArrayList<PlanNode> planNodes = new ArrayList<PlanNode>();
        for (IndexSegment indexSegment : indexSegments) {
            planNodes.add(this.makeInnerSegmentPlan(indexSegment, brokerRequest));
        }
        CombinePlanNode combinePlanNode = new CombinePlanNode(planNodes, brokerRequest, executorService, timeOutMs, this._numGroupsLimit);
        return new GlobalPlanImplV0(new InstanceResponsePlanNode(combinePlanNode));
    }

    public static boolean isFitForMetadataBasedPlan(BrokerRequest brokerRequest, IndexSegment indexSegment) {
        if (brokerRequest.getFilterQuery() != null || brokerRequest.isSetGroupBy()) {
            return false;
        }
        List<AggregationInfo> aggregationsInfo = brokerRequest.getAggregationsInfo();
        if (aggregationsInfo == null) {
            return false;
        }
        for (AggregationInfo aggInfo : aggregationsInfo) {
            if (InstancePlanMakerImplV2.isMetadataBasedAggregationFunction(aggInfo, indexSegment)) continue;
            return false;
        }
        return true;
    }

    private static boolean isMetadataBasedAggregationFunction(AggregationInfo aggregationInfo, IndexSegment indexSegment) {
        return AggregationFunctionType.getAggregationFunctionType(aggregationInfo.getAggregationType()) == AggregationFunctionType.COUNT;
    }

    public static boolean isFitForDictionaryBasedPlan(BrokerRequest brokerRequest, IndexSegment indexSegment) {
        if (brokerRequest.getFilterQuery() != null || brokerRequest.isSetGroupBy() || indexSegment.getSegmentMetadata().hasStarTree()) {
            return false;
        }
        List<AggregationInfo> aggregationsInfo = brokerRequest.getAggregationsInfo();
        if (aggregationsInfo == null) {
            return false;
        }
        for (AggregationInfo aggregationInfo : aggregationsInfo) {
            if (InstancePlanMakerImplV2.isDictionaryBasedAggregationFunction(aggregationInfo, indexSegment)) continue;
            return false;
        }
        return true;
    }

    private static boolean isDictionaryBasedAggregationFunction(AggregationInfo aggregationInfo, IndexSegment indexSegment) {
        String expression;
        AggregationFunctionType functionType = AggregationFunctionType.getAggregationFunctionType(aggregationInfo.getAggregationType());
        if (functionType.isOfType(AggregationFunctionType.MIN, AggregationFunctionType.MAX, AggregationFunctionType.MINMAXRANGE) && TransformExpressionTree.compileToExpressionTree(expression = AggregationFunctionUtils.getColumn(aggregationInfo)).isColumn()) {
            Dictionary dictionary = indexSegment.getDataSource(expression).getDictionary();
            return dictionary != null && dictionary.isSorted();
        }
        return false;
    }
}

