/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationExecutor;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.common.request.transform.TransformExpressionTree;

public class DefaultAggregationExecutor
implements AggregationExecutor {
    protected final int _numFunctions;
    protected final AggregationFunction[] _functions;
    protected final AggregationResultHolder[] _resultHolders;
    protected final TransformExpressionTree[] _expressions;

    public DefaultAggregationExecutor(@Nonnull AggregationFunctionContext[] functionContexts) {
        this._numFunctions = functionContexts.length;
        this._functions = new AggregationFunction[this._numFunctions];
        this._resultHolders = new AggregationResultHolder[this._numFunctions];
        this._expressions = new TransformExpressionTree[this._numFunctions];
        for (int i = 0; i < this._numFunctions; ++i) {
            AggregationFunction function;
            this._functions[i] = function = functionContexts[i].getAggregationFunction();
            this._resultHolders[i] = this._functions[i].createAggregationResultHolder();
            if (function.getType() == AggregationFunctionType.COUNT) continue;
            this._expressions[i] = TransformExpressionTree.compileToExpressionTree(functionContexts[i].getColumn());
        }
    }

    @Override
    public void aggregate(@Nonnull TransformBlock transformBlock) {
        int length = transformBlock.getNumDocs();
        for (int i = 0; i < this._numFunctions; ++i) {
            AggregationFunction function = this._functions[i];
            AggregationResultHolder resultHolder = this._resultHolders[i];
            if (function.getType() == AggregationFunctionType.COUNT) {
                function.aggregate(length, resultHolder, new BlockValSet[0]);
                continue;
            }
            function.aggregate(length, resultHolder, transformBlock.getBlockValueSet(this._expressions[i]));
        }
    }

    @Override
    public List<Object> getResult() {
        ArrayList<Object> aggregationResults = new ArrayList<Object>(this._numFunctions);
        for (int i = 0; i < this._numFunctions; ++i) {
            aggregationResults.add(this._functions[i].extractAggregationResult(this._resultHolders[i]));
        }
        return aggregationResults;
    }
}

