/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.com.google.common.math.DoubleMath;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.AggregationFunctionInitializer;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.segment.SegmentMetadata;

public class AggregationFunctionUtils {
    public static final String COLUMN_KEY = "column";

    private AggregationFunctionUtils() {
    }

    @Nonnull
    public static String getColumn(@Nonnull AggregationInfo aggregationInfo) {
        return aggregationInfo.getAggregationParams().get(COLUMN_KEY);
    }

    @Nonnull
    public static AggregationFunctionColumnPair getFunctionColumnPair(@Nonnull AggregationInfo aggregationInfo) {
        AggregationFunctionType functionType = AggregationFunctionType.getAggregationFunctionType(aggregationInfo.getAggregationType());
        return new AggregationFunctionColumnPair(functionType, AggregationFunctionUtils.getColumn(aggregationInfo));
    }

    @Nonnull
    public static AggregationFunctionContext getAggregationFunctionContext(@Nonnull AggregationInfo aggregationInfo) {
        String functionName = aggregationInfo.getAggregationType();
        AggregationFunction aggregationFunction = AggregationFunctionFactory.getAggregationFunction(functionName);
        return new AggregationFunctionContext(aggregationFunction, AggregationFunctionUtils.getColumn(aggregationInfo));
    }

    @Nonnull
    public static AggregationFunctionContext[] getAggregationFunctionContexts(@Nonnull List<AggregationInfo> aggregationInfos, @Nullable SegmentMetadata segmentMetadata) {
        int numAggregationFunctions = aggregationInfos.size();
        AggregationFunctionContext[] aggregationFunctionContexts = new AggregationFunctionContext[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            AggregationInfo aggregationInfo = aggregationInfos.get(i);
            aggregationFunctionContexts[i] = AggregationFunctionUtils.getAggregationFunctionContext(aggregationInfo);
        }
        if (segmentMetadata != null) {
            AggregationFunctionInitializer aggregationFunctionInitializer = new AggregationFunctionInitializer(segmentMetadata);
            for (AggregationFunctionContext aggregationFunctionContext : aggregationFunctionContexts) {
                aggregationFunctionContext.getAggregationFunction().accept(aggregationFunctionInitializer);
            }
        }
        return aggregationFunctionContexts;
    }

    @Nonnull
    public static AggregationFunction[] getAggregationFunctions(@Nonnull List<AggregationInfo> aggregationInfos) {
        int numAggregationFunctions = aggregationInfos.size();
        AggregationFunction[] aggregationFunctions = new AggregationFunction[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            aggregationFunctions[i] = AggregationFunctionFactory.getAggregationFunction(aggregationInfos.get(i).getAggregationType());
        }
        return aggregationFunctions;
    }

    @Nonnull
    public static boolean[] getAggregationFunctionsSelectStatus(@Nonnull List<AggregationInfo> aggregationInfos) {
        int numAggregationFunctions = aggregationInfos.size();
        boolean[] aggregationFunctionsStatus = new boolean[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            aggregationFunctionsStatus[i] = aggregationInfos.get(i).isIsInSelectList();
        }
        return aggregationFunctionsStatus;
    }

    @Nonnull
    public static String formatValue(@Nonnull Object value) {
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            if (doubleValue <= 9.223372036854776E18 && DoubleMath.isMathematicalInteger(doubleValue)) {
                return Long.toString(doubleValue.longValue()) + ".00000";
            }
            return String.format(Locale.US, "%1.5f", doubleValue);
        }
        return value.toString();
    }

    @Nonnull
    public static Serializable getSerializableValue(@Nonnull Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        return value.toString();
    }
}

