/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.DistinctCountHLLAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.common.data.FieldSpec;

public class DistinctCountHLLMVAggregationFunction
extends DistinctCountHLLAggregationFunction {
    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.DISTINCTCOUNTHLLMV;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.DISTINCTCOUNTHLLMV.getName() + "_" + column;
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        HyperLogLog hyperLogLog = DistinctCountHLLMVAggregationFunction.getHyperLogLog(aggregationResultHolder);
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: {
                int[][] intValues = blockValSets[0].getIntValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int value : intValues[i]) {
                        hyperLogLog.offer((Object)value);
                    }
                }
                break;
            }
            case LONG: {
                long[][] longValues = blockValSets[0].getLongValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (long value : longValues[i]) {
                        hyperLogLog.offer((Object)value);
                    }
                }
                break;
            }
            case FLOAT: {
                float[][] floatValues = blockValSets[0].getFloatValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (float value : floatValues[i]) {
                        hyperLogLog.offer((Object)Float.valueOf(value));
                    }
                }
                break;
            }
            case DOUBLE: {
                double[][] doubleValues = blockValSets[0].getDoubleValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (double value : doubleValues[i]) {
                        hyperLogLog.offer((Object)value);
                    }
                }
                break;
            }
            case STRING: {
                String[][] stringValues = blockValSets[0].getStringValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (String value : stringValues[i]) {
                        hyperLogLog.offer((Object)value);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_HLL_MV aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: {
                int[][] intValues = blockValSets[0].getIntValuesMV();
                for (int i = 0; i < length; ++i) {
                    HyperLogLog hyperLogLog = DistinctCountHLLMVAggregationFunction.getHyperLogLog(groupByResultHolder, groupKeyArray[i]);
                    for (int value : intValues[i]) {
                        hyperLogLog.offer((Object)value);
                    }
                }
                break;
            }
            case LONG: {
                long[][] longValues = blockValSets[0].getLongValuesMV();
                for (int i = 0; i < length; ++i) {
                    HyperLogLog hyperLogLog = DistinctCountHLLMVAggregationFunction.getHyperLogLog(groupByResultHolder, groupKeyArray[i]);
                    for (long value : longValues[i]) {
                        hyperLogLog.offer((Object)value);
                    }
                }
                break;
            }
            case FLOAT: {
                float[][] floatValues = blockValSets[0].getFloatValuesMV();
                for (int i = 0; i < length; ++i) {
                    HyperLogLog hyperLogLog = DistinctCountHLLMVAggregationFunction.getHyperLogLog(groupByResultHolder, groupKeyArray[i]);
                    for (float value : floatValues[i]) {
                        hyperLogLog.offer((Object)Float.valueOf(value));
                    }
                }
                break;
            }
            case DOUBLE: {
                double[][] doubleValues = blockValSets[0].getDoubleValuesMV();
                for (int i = 0; i < length; ++i) {
                    HyperLogLog hyperLogLog = DistinctCountHLLMVAggregationFunction.getHyperLogLog(groupByResultHolder, groupKeyArray[i]);
                    for (double value : doubleValues[i]) {
                        hyperLogLog.offer((Object)value);
                    }
                }
                break;
            }
            case STRING: {
                String[][] stringValues = blockValSets[0].getStringValuesMV();
                for (int i = 0; i < length; ++i) {
                    HyperLogLog hyperLogLog = DistinctCountHLLMVAggregationFunction.getHyperLogLog(groupByResultHolder, groupKeyArray[i]);
                    for (String value : stringValues[i]) {
                        hyperLogLog.offer((Object)value);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_HLL_MV aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: {
                int[][] intValues = blockValSets[0].getIntValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        HyperLogLog hyperLogLog = DistinctCountHLLMVAggregationFunction.getHyperLogLog(groupByResultHolder, groupKey);
                        for (int value : intValues[i]) {
                            hyperLogLog.offer((Object)value);
                        }
                    }
                }
                break;
            }
            case LONG: {
                long[][] longValues = blockValSets[0].getLongValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        HyperLogLog hyperLogLog = DistinctCountHLLMVAggregationFunction.getHyperLogLog(groupByResultHolder, groupKey);
                        for (long value : longValues[i]) {
                            hyperLogLog.offer((Object)value);
                        }
                    }
                }
                break;
            }
            case FLOAT: {
                float[][] floatValues = blockValSets[0].getFloatValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        HyperLogLog hyperLogLog = DistinctCountHLLMVAggregationFunction.getHyperLogLog(groupByResultHolder, groupKey);
                        for (float value : floatValues[i]) {
                            hyperLogLog.offer((Object)Float.valueOf(value));
                        }
                    }
                }
                break;
            }
            case DOUBLE: {
                double[][] doubleMVValues = blockValSets[0].getDoubleValuesMV();
                for (int i = 0; i < length; ++i) {
                    double[] doubleValues = doubleMVValues[i];
                    for (int groupKey : groupKeysArray[i]) {
                        HyperLogLog hyperLogLog = DistinctCountHLLMVAggregationFunction.getHyperLogLog(groupByResultHolder, groupKey);
                        for (double value : doubleValues) {
                            hyperLogLog.offer((Object)value);
                        }
                    }
                }
                break;
            }
            case STRING: {
                String[][] stringMVValues = blockValSets[0].getStringValuesMV();
                for (int i = 0; i < length; ++i) {
                    String[] stringValues = stringMVValues[i];
                    for (int groupKey : groupKeysArray[i]) {
                        HyperLogLog hyperLogLog = DistinctCountHLLMVAggregationFunction.getHyperLogLog(groupByResultHolder, groupKey);
                        for (String value : stringValues) {
                            hyperLogLog.offer((Object)value);
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_HLL_MV aggregation function: " + (Object)((Object)valueType));
            }
        }
    }
}

