/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.DistinctCountAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.common.data.FieldSpec;

public class DistinctCountMVAggregationFunction
extends DistinctCountAggregationFunction {
    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.DISTINCTCOUNTMV;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.DISTINCTCOUNTMV.getName() + "_" + column;
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        IntOpenHashSet valueSet = DistinctCountMVAggregationFunction.getValueSet(aggregationResultHolder);
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: {
                int[][] intValues = blockValSets[0].getIntValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int value : intValues[i]) {
                        valueSet.add(value);
                    }
                }
                break;
            }
            case LONG: {
                long[][] longValues = blockValSets[0].getLongValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (long value : longValues[i]) {
                        valueSet.add(Long.hashCode(value));
                    }
                }
                break;
            }
            case FLOAT: {
                float[][] floatValues = blockValSets[0].getFloatValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (float value : floatValues[i]) {
                        valueSet.add(Float.hashCode(value));
                    }
                }
            }
            case DOUBLE: {
                double[][] doubleValues = blockValSets[0].getDoubleValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (double value : doubleValues[i]) {
                        valueSet.add(Double.hashCode(value));
                    }
                }
                break;
            }
            case STRING: {
                String[][] stringValues = blockValSets[0].getStringValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (String value : stringValues[i]) {
                        valueSet.add(value.hashCode());
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_MV aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: {
                int[][] intValues = blockValSets[0].getIntValuesMV();
                for (int i = 0; i < length; ++i) {
                    IntOpenHashSet valueSet = DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i]);
                    for (int value : intValues[i]) {
                        valueSet.add(value);
                    }
                }
                break;
            }
            case LONG: {
                long[][] longValues = blockValSets[0].getLongValuesMV();
                for (int i = 0; i < length; ++i) {
                    IntOpenHashSet valueSet = DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i]);
                    for (long value : longValues[i]) {
                        valueSet.add(Long.hashCode(value));
                    }
                }
                break;
            }
            case FLOAT: {
                float[][] floatValues = blockValSets[0].getFloatValuesMV();
                for (int i = 0; i < length; ++i) {
                    IntOpenHashSet valueSet = DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i]);
                    for (float value : floatValues[i]) {
                        valueSet.add(Float.hashCode(value));
                    }
                }
                break;
            }
            case DOUBLE: {
                double[][] doubleValues = blockValSets[0].getDoubleValuesMV();
                for (int i = 0; i < length; ++i) {
                    IntOpenHashSet valueSet = DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i]);
                    for (double value : doubleValues[i]) {
                        valueSet.add(Double.hashCode(value));
                    }
                }
                break;
            }
            case STRING: {
                String[][] stringValues = blockValSets[0].getStringValuesMV();
                for (int i = 0; i < length; ++i) {
                    IntOpenHashSet valueSet = DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i]);
                    for (String value : stringValues[i]) {
                        valueSet.add(value.hashCode());
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_MV aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: {
                int[][] intValues = blockValSets[0].getIntValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        IntOpenHashSet valueSet = DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKey);
                        for (int value : intValues[i]) {
                            valueSet.add(value);
                        }
                    }
                }
                break;
            }
            case LONG: {
                long[][] longValues = blockValSets[0].getLongValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        IntOpenHashSet valueSet = DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKey);
                        for (long value : longValues[i]) {
                            valueSet.add(Long.hashCode(value));
                        }
                    }
                }
                break;
            }
            case FLOAT: {
                float[][] floatValues = blockValSets[0].getFloatValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        IntOpenHashSet valueSet = DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKey);
                        for (float value : floatValues[i]) {
                            valueSet.add(Float.hashCode(value));
                        }
                    }
                }
                break;
            }
            case DOUBLE: {
                double[][] doubleValues = blockValSets[0].getDoubleValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        IntOpenHashSet valueSet = DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKey);
                        for (double value : doubleValues[i]) {
                            valueSet.add(Double.hashCode(value));
                        }
                    }
                }
                break;
            }
            case STRING: {
                String[][] stringValues = blockValSets[0].getStringValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        IntOpenHashSet valueSet = DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKey);
                        for (String value : stringValues[i]) {
                            valueSet.add(value.hashCode());
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_MV aggregation function: " + (Object)((Object)valueType));
            }
        }
    }
}

