/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.MinMaxRangeAggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;

public class MinMaxRangeMVAggregationFunction
extends MinMaxRangeAggregationFunction {
    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.MINMAXRANGEMV;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.MINMAXRANGEMV.getName() + "_" + column;
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        double[][] valuesArray = blockValSets[0].getDoubleValuesMV();
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < length; ++i) {
            double[] values;
            for (double value : values = valuesArray[i]) {
                if (value < min) {
                    min = value;
                }
                if (!(value > max)) continue;
                max = value;
            }
        }
        this.setAggregationResult(aggregationResultHolder, min, max);
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        double[][] valuesArray = blockValSets[0].getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            this.aggregateOnGroupKey(groupKeyArray[i], groupByResultHolder, valuesArray[i]);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        double[][] valuesArray = blockValSets[0].getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            double[] values = valuesArray[i];
            for (int groupKey : groupKeysArray[i]) {
                this.aggregateOnGroupKey(groupKey, groupByResultHolder, values);
            }
        }
    }

    private void aggregateOnGroupKey(int groupKey, @Nonnull GroupByResultHolder groupByResultHolder, double[] values) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (double value : values) {
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        this.setGroupByResult(groupKey, groupByResultHolder, min, max);
    }
}

