/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionVisitorBase;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.common.utils.DataSchema;

public class PercentileAggregationFunction
implements AggregationFunction<DoubleArrayList, Double> {
    private static final double DEFAULT_FINAL_RESULT = Double.NEGATIVE_INFINITY;
    protected final int _percentile;

    public PercentileAggregationFunction(int percentile) {
        this._percentile = percentile;
    }

    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.PERCENTILE;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.PERCENTILE.getName() + this._percentile + "_" + column;
    }

    @Override
    public void accept(@Nonnull AggregationFunctionVisitorBase visitor) {
        visitor.visit(this);
    }

    @Override
    @Nonnull
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    @Nonnull
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        DoubleArrayList valueList = PercentileAggregationFunction.getValueList(aggregationResultHolder);
        double[] valueArray = blockValSets[0].getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            valueList.add(valueArray[i]);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        double[] valueArray = blockValSets[0].getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            DoubleArrayList valueList = PercentileAggregationFunction.getValueList(groupByResultHolder, groupKeyArray[i]);
            valueList.add(valueArray[i]);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        double[] valueArray = blockValSets[0].getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            double value = valueArray[i];
            for (int groupKey : groupKeysArray[i]) {
                DoubleArrayList valueList = PercentileAggregationFunction.getValueList(groupByResultHolder, groupKey);
                valueList.add(value);
            }
        }
    }

    @Override
    @Nonnull
    public DoubleArrayList extractAggregationResult(@Nonnull AggregationResultHolder aggregationResultHolder) {
        DoubleArrayList doubleArrayList = (DoubleArrayList)aggregationResultHolder.getResult();
        if (doubleArrayList == null) {
            return new DoubleArrayList();
        }
        return doubleArrayList;
    }

    @Override
    @Nonnull
    public DoubleArrayList extractGroupByResult(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        DoubleArrayList doubleArrayList = (DoubleArrayList)groupByResultHolder.getResult(groupKey);
        if (doubleArrayList == null) {
            return new DoubleArrayList();
        }
        return doubleArrayList;
    }

    @Override
    @Nonnull
    public DoubleArrayList merge(@Nonnull DoubleArrayList intermediateResult1, @Nonnull DoubleArrayList intermediateResult2) {
        intermediateResult1.addAll((DoubleList)intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return false;
    }

    @Override
    @Nonnull
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    @Nonnull
    public Double extractFinalResult(@Nonnull DoubleArrayList intermediateResult) {
        int size = intermediateResult.size();
        if (size == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        double[] values = intermediateResult.elements();
        Arrays.sort(values, 0, size);
        if (this._percentile == 100) {
            return values[size - 1];
        }
        return values[(int)((long)size * (long)this._percentile / 100L)];
    }

    protected static DoubleArrayList getValueList(@Nonnull AggregationResultHolder aggregationResultHolder) {
        DoubleArrayList valueList = (DoubleArrayList)aggregationResultHolder.getResult();
        if (valueList == null) {
            valueList = new DoubleArrayList();
            aggregationResultHolder.setValue(valueList);
        }
        return valueList;
    }

    protected static DoubleArrayList getValueList(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        DoubleArrayList valueList = (DoubleArrayList)groupByResultHolder.getResult(groupKey);
        if (valueList == null) {
            valueList = new DoubleArrayList();
            groupByResultHolder.setValueForKey(groupKey, valueList);
        }
        return valueList;
    }
}

