/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function;

import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.TDigest;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionVisitorBase;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.utils.DataSchema;

public class PercentileTDigestAggregationFunction
implements AggregationFunction<TDigest, Double> {
    public static final int DEFAULT_TDIGEST_COMPRESSION = 100;
    protected final int _percentile;

    public PercentileTDigestAggregationFunction(int percentile) {
        this._percentile = percentile;
    }

    @Override
    @Nonnull
    public AggregationFunctionType getType() {
        return AggregationFunctionType.PERCENTILETDIGEST;
    }

    @Override
    @Nonnull
    public String getColumnName(@Nonnull String column) {
        return AggregationFunctionType.PERCENTILETDIGEST.getName() + this._percentile + "_" + column;
    }

    @Override
    public void accept(@Nonnull AggregationFunctionVisitorBase visitor) {
        visitor.visit(this);
    }

    @Override
    @Nonnull
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    @Nonnull
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, @Nonnull AggregationResultHolder aggregationResultHolder, BlockValSet ... blockValSets) {
        TDigest tDigest = PercentileTDigestAggregationFunction.getTDigest(aggregationResultHolder);
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                double[] valueArray = blockValSets[0].getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    tDigest.add(valueArray[i]);
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSets[0].getBytesValuesSV();
                for (int i = 0; i < length; ++i) {
                    tDigest.add(ObjectSerDeUtils.TDIGEST_SER_DE.deserialize(ByteBuffer.wrap(bytesValues[i])));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for PERCENTILE_TDIGEST aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, @Nonnull int[] groupKeyArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                double[] valueArray = blockValSets[0].getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    TDigest tDigest = PercentileTDigestAggregationFunction.getTDigest(groupByResultHolder, groupKeyArray[i]);
                    tDigest.add(valueArray[i]);
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSets[0].getBytesValuesSV();
                for (int i = 0; i < length; ++i) {
                    TDigest tDigest = PercentileTDigestAggregationFunction.getTDigest(groupByResultHolder, groupKeyArray[i]);
                    tDigest.add(ObjectSerDeUtils.TDIGEST_SER_DE.deserialize(ByteBuffer.wrap(bytesValues[i])));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for PERCENTILE_TDIGEST aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, @Nonnull int[][] groupKeysArray, @Nonnull GroupByResultHolder groupByResultHolder, BlockValSet ... blockValSets) {
        FieldSpec.DataType valueType = blockValSets[0].getValueType();
        switch (valueType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                TDigest tDigest;
                double[] valueArray = blockValSets[0].getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    double value = valueArray[i];
                    for (int groupKey : groupKeysArray[i]) {
                        tDigest = PercentileTDigestAggregationFunction.getTDigest(groupByResultHolder, groupKey);
                        tDigest.add(value);
                    }
                }
            }
            case BYTES: {
                TDigest tDigest;
                byte[][] bytesValues = blockValSets[0].getBytesValuesSV();
                for (int i = 0; i < length; ++i) {
                    TDigest value = ObjectSerDeUtils.TDIGEST_SER_DE.deserialize(ByteBuffer.wrap(bytesValues[i]));
                    for (int groupKey : groupKeysArray[i]) {
                        tDigest = PercentileTDigestAggregationFunction.getTDigest(groupByResultHolder, groupKey);
                        tDigest.add(value);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for PERCENTILE_TDIGEST aggregation function: " + (Object)((Object)valueType));
            }
        }
    }

    @Override
    @Nonnull
    public TDigest extractAggregationResult(@Nonnull AggregationResultHolder aggregationResultHolder) {
        TDigest tDigest = (TDigest)aggregationResultHolder.getResult();
        if (tDigest == null) {
            return TDigest.createMergingDigest((double)100.0);
        }
        return tDigest;
    }

    @Override
    @Nonnull
    public TDigest extractGroupByResult(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        TDigest tDigest = (TDigest)groupByResultHolder.getResult(groupKey);
        if (tDigest == null) {
            return TDigest.createMergingDigest((double)100.0);
        }
        return tDigest;
    }

    @Override
    @Nonnull
    public TDigest merge(@Nonnull TDigest intermediateResult1, @Nonnull TDigest intermediateResult2) {
        intermediateResult1.add(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return false;
    }

    @Override
    @Nonnull
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    @Nonnull
    public Double extractFinalResult(@Nonnull TDigest intermediateResult) {
        return PercentileTDigestAggregationFunction.calculatePercentile(intermediateResult, this._percentile);
    }

    public static double calculatePercentile(@Nonnull TDigest tDigest, int percentile) {
        if (tDigest.size() == 1L) {
            return ((Centroid)tDigest.centroids().iterator().next()).mean();
        }
        return tDigest.quantile((double)percentile / 100.0);
    }

    protected static TDigest getTDigest(@Nonnull AggregationResultHolder aggregationResultHolder) {
        TDigest tDigest = (TDigest)aggregationResultHolder.getResult();
        if (tDigest == null) {
            tDigest = TDigest.createMergingDigest((double)100.0);
            aggregationResultHolder.setValue(tDigest);
        }
        return tDigest;
    }

    protected static TDigest getTDigest(@Nonnull GroupByResultHolder groupByResultHolder, int groupKey) {
        TDigest tDigest = (TDigest)groupByResultHolder.getResult(groupKey);
        if (tDigest == null) {
            tDigest = TDigest.createMergingDigest((double)100.0);
            groupByResultHolder.setValueForKey(groupKey, tDigest);
        }
        return tDigest;
    }
}

