/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.DictionaryBasedGroupKeyGenerator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByExecutor;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.NoDictionaryMultiColumnGroupKeyGenerator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.NoDictionarySingleColumnGroupKeyGenerator;
import org.apache.pinot.common.request.GroupBy;
import org.apache.pinot.common.request.transform.TransformExpressionTree;

public class DefaultGroupByExecutor
implements GroupByExecutor {
    private static final ThreadLocal<int[]> THREAD_LOCAL_SV_GROUP_KEYS = ThreadLocal.withInitial(() -> new int[DocIdSetPlanNode.MAX_DOC_PER_CALL]);
    private static final ThreadLocal<int[][]> THREAD_LOCAL_MV_GROUP_KEYS = ThreadLocal.withInitial(() -> new int[DocIdSetPlanNode.MAX_DOC_PER_CALL][]);
    protected final int _numFunctions;
    protected final AggregationFunction[] _functions;
    protected final TransformExpressionTree[] _aggregationExpressions;
    protected final GroupKeyGenerator _groupKeyGenerator;
    protected final GroupByResultHolder[] _resultHolders;
    protected final boolean _hasMVGroupByExpression;
    protected final boolean _hasNoDictionaryGroupByExpression;
    protected final int[] _svGroupKeys;
    protected final int[][] _mvGroupKeys;

    public DefaultGroupByExecutor(@Nonnull AggregationFunctionContext[] functionContexts, @Nonnull GroupBy groupBy, int maxInitialResultHolderCapacity, int numGroupsLimit, @Nonnull TransformOperator transformOperator) {
        this._numFunctions = functionContexts.length;
        this._functions = new AggregationFunction[this._numFunctions];
        this._aggregationExpressions = new TransformExpressionTree[this._numFunctions];
        for (int i = 0; i < this._numFunctions; ++i) {
            AggregationFunction function;
            this._functions[i] = function = functionContexts[i].getAggregationFunction();
            if (function.getType() == AggregationFunctionType.COUNT) continue;
            this._aggregationExpressions[i] = TransformExpressionTree.compileToExpressionTree(functionContexts[i].getColumn());
        }
        List<String> groupByExpressionStrings = groupBy.getExpressions();
        int numGroupByExpressions = groupByExpressionStrings.size();
        boolean hasMVGroupByExpression = false;
        boolean hasNoDictionaryGroupByExpression = false;
        TransformExpressionTree[] groupByExpressions = new TransformExpressionTree[numGroupByExpressions];
        for (int i = 0; i < numGroupByExpressions; ++i) {
            groupByExpressions[i] = TransformExpressionTree.compileToExpressionTree(groupByExpressionStrings.get(i));
            TransformResultMetadata transformResultMetadata = transformOperator.getResultMetadata(groupByExpressions[i]);
            hasMVGroupByExpression |= !transformResultMetadata.isSingleValue();
            hasNoDictionaryGroupByExpression |= !transformResultMetadata.hasDictionary();
        }
        this._hasMVGroupByExpression = hasMVGroupByExpression;
        this._hasNoDictionaryGroupByExpression = hasNoDictionaryGroupByExpression;
        this._groupKeyGenerator = this._hasNoDictionaryGroupByExpression ? (numGroupByExpressions == 1 ? new NoDictionarySingleColumnGroupKeyGenerator(transformOperator, groupByExpressions[0], numGroupsLimit) : new NoDictionaryMultiColumnGroupKeyGenerator(transformOperator, groupByExpressions, numGroupsLimit)) : new DictionaryBasedGroupKeyGenerator(transformOperator, groupByExpressions, numGroupsLimit, maxInitialResultHolderCapacity);
        int maxNumResults = this._groupKeyGenerator.getGlobalGroupKeyUpperBound();
        int initialCapacity = Math.min(maxNumResults, maxInitialResultHolderCapacity);
        this._resultHolders = new GroupByResultHolder[this._numFunctions];
        for (int i = 0; i < this._numFunctions; ++i) {
            this._resultHolders[i] = this._functions[i].createGroupByResultHolder(initialCapacity, maxNumResults);
        }
        if (this._hasMVGroupByExpression) {
            this._svGroupKeys = null;
            this._mvGroupKeys = THREAD_LOCAL_MV_GROUP_KEYS.get();
        } else {
            this._svGroupKeys = THREAD_LOCAL_SV_GROUP_KEYS.get();
            this._mvGroupKeys = null;
        }
    }

    @Override
    public void process(@Nonnull TransformBlock transformBlock) {
        if (this._hasMVGroupByExpression) {
            this._groupKeyGenerator.generateKeysForBlock(transformBlock, this._mvGroupKeys);
        } else {
            this._groupKeyGenerator.generateKeysForBlock(transformBlock, this._svGroupKeys);
        }
        int length = transformBlock.getNumDocs();
        int capacityNeeded = this._groupKeyGenerator.getCurrentGroupKeyUpperBound();
        for (int i = 0; i < this._numFunctions; ++i) {
            GroupByResultHolder resultHolder = this._resultHolders[i];
            resultHolder.ensureCapacity(capacityNeeded);
            this.aggregate(transformBlock, length, i);
        }
    }

    protected void aggregate(@Nonnull TransformBlock transformBlock, int length, int functionIndex) {
        AggregationFunction function = this._functions[functionIndex];
        GroupByResultHolder resultHolder = this._resultHolders[functionIndex];
        if (function.getType() == AggregationFunctionType.COUNT) {
            if (this._hasMVGroupByExpression) {
                function.aggregateGroupByMV(length, this._mvGroupKeys, resultHolder, new BlockValSet[0]);
            } else {
                function.aggregateGroupBySV(length, this._svGroupKeys, resultHolder, new BlockValSet[0]);
            }
        } else {
            BlockValSet blockValueSet = transformBlock.getBlockValueSet(this._aggregationExpressions[functionIndex]);
            if (this._hasMVGroupByExpression) {
                function.aggregateGroupByMV(length, this._mvGroupKeys, resultHolder, blockValueSet);
            } else {
                function.aggregateGroupBySV(length, this._svGroupKeys, resultHolder, blockValueSet);
            }
        }
    }

    @Override
    public AggregationGroupByResult getResult() {
        return new AggregationGroupByResult(this._groupKeyGenerator, this._functions, this._resultHolders);
    }
}

