/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.utils;

import it.unimi.dsi.fastutil.floats.Float2IntMap;
import it.unimi.dsi.fastutil.floats.Float2IntOpenHashMap;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.utils.BaseValueToIdMap;

public class FloatToIdMap
extends BaseValueToIdMap {
    Float2IntMap _valueToIdMap = new Float2IntOpenHashMap();
    FloatList _idToValueMap;

    public FloatToIdMap() {
        this._valueToIdMap.defaultReturnValue(-1);
        this._idToValueMap = new FloatArrayList();
    }

    @Override
    public int put(float value) {
        int id = this._valueToIdMap.get(value);
        if (id == -1) {
            id = this._idToValueMap.size();
            this._valueToIdMap.put(value, id);
            this._idToValueMap.add(value);
        }
        return id;
    }

    @Override
    public float getFloat(int id) {
        assert (id < this._idToValueMap.size());
        return ((Float)this._idToValueMap.get(id)).floatValue();
    }

    @Override
    public String getString(int id) {
        assert (id < this._idToValueMap.size());
        return Float.valueOf(this._idToValueMap.getFloat(id)).toString();
    }
}

