/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.executor;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.commons.configuration.ConfigurationException;
import org.apache.pinot.$internal.org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.$internal.org.apache.pinot.core.common.datatable.DataTableImplV2;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.SegmentDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.TableDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.Plan;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.maker.InstancePlanMakerImplV2;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.maker.PlanMaker;
import org.apache.pinot.$internal.org.apache.pinot.core.query.config.QueryExecutorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.query.exception.BadQueryRequestException;
import org.apache.pinot.$internal.org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.$internal.org.apache.pinot.core.query.pruner.SegmentPrunerService;
import org.apache.pinot.$internal.org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.$internal.org.apache.pinot.core.query.request.context.TimerContext;
import org.apache.pinot.$internal.org.apache.pinot.core.util.trace.TraceContext;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.metrics.ServerQueryPhase;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.utils.DataTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ServerQueryExecutorV1Impl
implements QueryExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerQueryExecutorV1Impl.class);
    private static final boolean PRINT_QUERY_PLAN = false;
    private InstanceDataManager _instanceDataManager = null;
    private SegmentPrunerService _segmentPrunerService = null;
    private PlanMaker _planMaker = null;
    private long _defaultTimeOutMs = 15000L;
    private final Map<String, Long> _tableTimeoutMs = new ConcurrentHashMap<String, Long>();
    private ServerMetrics _serverMetrics;

    @Override
    public synchronized void init(Configuration config, InstanceDataManager instanceDataManager, ServerMetrics serverMetrics) throws ConfigurationException {
        this._instanceDataManager = instanceDataManager;
        this._serverMetrics = serverMetrics;
        QueryExecutorConfig queryExecutorConfig = new QueryExecutorConfig(config);
        if (queryExecutorConfig.getTimeOut() > 0L) {
            this._defaultTimeOutMs = queryExecutorConfig.getTimeOut();
        }
        LOGGER.info("Default timeout for query executor : {}", (Object)this._defaultTimeOutMs);
        LOGGER.info("Trying to build SegmentPrunerService");
        this._segmentPrunerService = new SegmentPrunerService(queryExecutorConfig.getPrunerConfig());
        LOGGER.info("Trying to build QueryPlanMaker");
        this._planMaker = new InstancePlanMakerImplV2(queryExecutorConfig);
        LOGGER.info("Trying to build QueryExecutorTimer");
    }

    @Override
    public synchronized void start() {
        LOGGER.info("Query executor started");
    }

    @Override
    public synchronized void shutDown() {
        LOGGER.info("Query executor shut down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTable processQuery(ServerQueryRequest queryRequest, ExecutorService executorService) {
        DataTable dataTable;
        int numSegmentsQueried;
        long requestId;
        TimerContext.Timer queryProcessingTimer;
        block18: {
            TimerContext timerContext = queryRequest.getTimerContext();
            TimerContext.Timer schedulerWaitTimer = timerContext.getPhaseTimer(ServerQueryPhase.SCHEDULER_WAIT);
            if (schedulerWaitTimer != null) {
                schedulerWaitTimer.stopAndRecord();
            }
            long querySchedulingTimeMs = System.currentTimeMillis() - timerContext.getQueryArrivalTimeMs();
            queryProcessingTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.QUERY_PROCESSING);
            requestId = queryRequest.getRequestId();
            BrokerRequest brokerRequest = queryRequest.getBrokerRequest();
            LOGGER.debug("Incoming request Id: {}, query: {}", (Object)requestId, (Object)brokerRequest);
            String tableNameWithType = queryRequest.getTableNameWithType();
            long queryTimeoutMs = this._tableTimeoutMs.getOrDefault(tableNameWithType, this._defaultTimeOutMs);
            long remainingTimeMs = queryTimeoutMs - querySchedulingTimeMs;
            if (remainingTimeMs <= 0L) {
                this._serverMetrics.addMeteredQueryValue(brokerRequest, ServerMeter.SCHEDULING_TIMEOUT_EXCEPTIONS, 1L);
                String errorMessage = String.format("Query scheduling took %dms (longer than query timeout of %dms)", querySchedulingTimeMs, queryTimeoutMs);
                DataTableImplV2 dataTable2 = new DataTableImplV2();
                dataTable2.addException(QueryException.getException(QueryException.QUERY_SCHEDULING_TIMEOUT_ERROR, errorMessage));
                LOGGER.error("{} while processing requestId: {}", (Object)errorMessage, (Object)requestId);
                return dataTable2;
            }
            TableDataManager tableDataManager = this._instanceDataManager.getTableDataManager(tableNameWithType);
            Preconditions.checkState(tableDataManager != null, "Failed to find data manager for table: " + tableNameWithType);
            List<SegmentDataManager> segmentDataManagers = tableDataManager.acquireSegments(queryRequest.getSegmentsToQuery());
            numSegmentsQueried = segmentDataManagers.size();
            boolean enableTrace = queryRequest.isEnableTrace();
            if (enableTrace) {
                TraceContext.register(requestId);
            }
            dataTable = null;
            try {
                TimerContext.Timer segmentPruneTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.SEGMENT_PRUNING);
                long totalRawDocs = this.pruneSegments(tableDataManager, segmentDataManagers, queryRequest);
                segmentPruneTimer.stopAndRecord();
                int numSegmentsMatchedAfterPruning = segmentDataManagers.size();
                LOGGER.debug("Matched {} segments after pruning", (Object)numSegmentsMatchedAfterPruning);
                if (numSegmentsMatchedAfterPruning == 0) {
                    dataTable = DataTableBuilder.buildEmptyDataTable(brokerRequest);
                    Map<String, String> metadata = dataTable.getMetadata();
                    metadata.put("totalDocs", String.valueOf(totalRawDocs));
                    metadata.put("numDocsScanned", "0");
                    metadata.put("numEntriesScannedInFilter", "0");
                    metadata.put("numEntriesScannedPostFilter", "0");
                    metadata.put("numSegmentsProcessed", "0");
                    metadata.put("numSegmentsMatched", "0");
                } else {
                    TimerContext.Timer planBuildTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.BUILD_QUERY_PLAN);
                    Plan globalQueryPlan = this._planMaker.makeInterSegmentPlan(segmentDataManagers, brokerRequest, executorService, remainingTimeMs);
                    planBuildTimer.stopAndRecord();
                    TimerContext.Timer planExecTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.QUERY_PLAN_EXECUTION);
                    dataTable = globalQueryPlan.execute();
                    planExecTimer.stopAndRecord();
                    dataTable.getMetadata().put("totalDocs", Long.toString(totalRawDocs));
                }
            }
            catch (Exception e) {
                this._serverMetrics.addMeteredQueryValue(brokerRequest, ServerMeter.QUERY_EXECUTION_EXCEPTIONS, 1L);
                if (e instanceof BadQueryRequestException) {
                    LOGGER.info("Caught BadQueryRequestException while processing requestId: {}, {}", (Object)requestId, (Object)e.getMessage());
                } else {
                    LOGGER.error("Exception processing requestId {}", (Object)requestId, (Object)e);
                }
                dataTable = new DataTableImplV2();
                dataTable.addException(QueryException.getException(QueryException.QUERY_EXECUTION_ERROR, e));
                break block18;
            }
            finally {
                for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                    tableDataManager.releaseSegment(segmentDataManager);
                }
                if (enableTrace) {
                    if (dataTable != null) {
                        dataTable.getMetadata().put("traceInfo", TraceContext.getTraceInfo());
                    }
                    TraceContext.unregister();
                }
            }
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                tableDataManager.releaseSegment(segmentDataManager);
            }
            if (enableTrace) {
                if (dataTable != null) {
                    dataTable.getMetadata().put("traceInfo", TraceContext.getTraceInfo());
                }
                TraceContext.unregister();
            }
        }
        queryProcessingTimer.stopAndRecord();
        long queryProcessingTime = queryProcessingTimer.getDurationMs();
        dataTable.getMetadata().put("numSegmentsQueried", Integer.toString(numSegmentsQueried));
        dataTable.getMetadata().put("timeUsedMs", Long.toString(queryProcessingTime));
        LOGGER.debug("Query processing time for request Id - {}: {}", (Object)requestId, (Object)queryProcessingTime);
        LOGGER.debug("InstanceResponse for request Id - {}: {}", (Object)requestId, (Object)dataTable);
        return dataTable;
    }

    private long pruneSegments(TableDataManager tableDataManager, List<SegmentDataManager> segmentDataManagers, ServerQueryRequest serverQueryRequest) {
        long totalRawDocs = 0L;
        Iterator<SegmentDataManager> iterator = segmentDataManagers.iterator();
        while (iterator.hasNext()) {
            SegmentDataManager segmentDataManager = iterator.next();
            IndexSegment indexSegment = segmentDataManager.getSegment();
            totalRawDocs += (long)indexSegment.getSegmentMetadata().getTotalRawDocs();
            if (!this._segmentPrunerService.prune(indexSegment, serverQueryRequest)) continue;
            iterator.remove();
            tableDataManager.releaseSegment(segmentDataManager);
        }
        return totalRawDocs;
    }

    @Override
    public void setTableTimeoutMs(String tableNameWithType, long timeOutMs) {
        this._tableTimeoutMs.put(tableNameWithType, timeOutMs);
    }
}

