/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.pruner;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.query.pruner.AbstractSegmentPruner;
import org.apache.pinot.$internal.org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.ColumnMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.BloomFilterReader;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.request.FilterQueryTree;

public class PartitionSegmentPruner
extends AbstractSegmentPruner {
    @Override
    public void init(Configuration config) {
    }

    @Override
    public boolean prune(IndexSegment segment, ServerQueryRequest queryRequest) {
        FilterQueryTree filterQueryTree = queryRequest.getFilterQueryTree();
        return this.prune(segment, filterQueryTree);
    }

    public boolean prune(IndexSegment segment, FilterQueryTree filterQueryTree) {
        if (filterQueryTree == null) {
            return false;
        }
        Map<String, ColumnMetadata> columnMetadataMap = ((SegmentMetadataImpl)segment.getSegmentMetadata()).getColumnMetadataMap();
        return columnMetadataMap != null && this.pruneSegment(filterQueryTree, columnMetadataMap, Collections.emptyMap());
    }

    @Override
    public boolean pruneSegment(FilterQueryTree filterQueryTree, Map<String, ColumnMetadata> columnMetadataMap, Map<String, BloomFilterReader> bloomFilterMap) {
        List<FilterQueryTree> children = filterQueryTree.getChildren();
        if (children != null && !children.isEmpty()) {
            return this.pruneNonLeaf(filterQueryTree, columnMetadataMap, bloomFilterMap);
        }
        if (filterQueryTree.getOperator() != FilterOperator.EQUALITY) {
            return false;
        }
        String column = filterQueryTree.getColumn();
        ColumnMetadata columnMetadata = columnMetadataMap.get(column);
        if (columnMetadata == null) {
            return true;
        }
        PartitionFunction partitionFunction = columnMetadata.getPartitionFunction();
        if (partitionFunction != null) {
            Comparable value = PartitionSegmentPruner.getValue(filterQueryTree.getValue().get(0), columnMetadata.getDataType());
            int partition = partitionFunction.getPartition(value);
            return !columnMetadata.getPartitions().contains(partition);
        }
        return false;
    }
}

