/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.reduce;

import org.apache.pinot.$internal.org.apache.pinot.core.query.reduce.ComparisonFunction;
import org.apache.pinot.common.request.AggregationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BetweenComparison
extends ComparisonFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(BetweenComparison.class);
    private double _rightValue;
    private double _leftValue;

    public BetweenComparison(String leftValue, String rightValue, AggregationInfo aggregationInfo) {
        super(aggregationInfo);
        try {
            this._leftValue = Double.parseDouble(leftValue);
            this._rightValue = Double.parseDouble(rightValue);
        }
        catch (Exception e) {
            LOGGER.info("Exception in creating HAVING clause BETWEEN predicate", (Throwable)e);
        }
    }

    @Override
    public boolean isComparisonValid(String aggResult) {
        try {
            double middleValue = Double.parseDouble(aggResult);
            return middleValue >= this._leftValue && middleValue <= this._rightValue;
        }
        catch (Exception e) {
            LOGGER.info("Exception in applying HAVING clause BETWEEN predicate", (Throwable)e);
            return false;
        }
    }

    public double getRightValue() {
        return this._rightValue;
    }

    public double getLeftValue() {
        return this._leftValue;
    }
}

