/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.reduce;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByTrimmingService;
import org.apache.pinot.$internal.org.apache.pinot.core.query.reduce.HavingClauseComparisonTree;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.SelectionOperatorService;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.common.config.TableNameBuilder;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.query.ReduceService;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.GroupBy;
import org.apache.pinot.common.request.HavingFilterQuery;
import org.apache.pinot.common.request.HavingFilterQueryMap;
import org.apache.pinot.common.request.Selection;
import org.apache.pinot.common.response.ServerInstance;
import org.apache.pinot.common.response.broker.AggregationResult;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.GroupByResult;
import org.apache.pinot.common.response.broker.QueryProcessingException;
import org.apache.pinot.common.response.broker.SelectionResults;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BrokerReduceService
implements ReduceService<BrokerResponseNative> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerReduceService.class);

    @Override
    @Nonnull
    public BrokerResponseNative reduceOnDataTable(@Nonnull BrokerRequest brokerRequest, @Nonnull Map<ServerInstance, DataTable> dataTableMap, @Nullable BrokerMetrics brokerMetrics) {
        if (dataTableMap.size() == 0) {
            return BrokerResponseNative.empty();
        }
        BrokerResponseNative brokerResponseNative = new BrokerResponseNative();
        List<QueryProcessingException> processingExceptions = brokerResponseNative.getProcessingExceptions();
        long numDocsScanned = 0L;
        long numEntriesScannedInFilter = 0L;
        long numEntriesScannedPostFilter = 0L;
        long numSegmentsQueried = 0L;
        long numSegmentsProcessed = 0L;
        long numSegmentsMatched = 0L;
        long numTotalRawDocs = 0L;
        boolean numGroupsLimitReached = false;
        DataSchema cachedDataSchema = null;
        Iterator<Map.Entry<ServerInstance, DataTable>> iterator = dataTableMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String numTotalRawDocsString;
            String numSegmentsMatchedString;
            String numSegmentsProcessedString;
            String numSegmentsQueriedString;
            String numEntriesScannedPostFilterString;
            String numEntriesScannedInFilterString;
            Map.Entry<ServerInstance, DataTable> entry = iterator.next();
            ServerInstance serverInstance = entry.getKey();
            DataTable dataTable = entry.getValue();
            Map<String, String> metadata = dataTable.getMetadata();
            if (brokerRequest.isEnableTrace()) {
                brokerResponseNative.getTraceInfo().put(serverInstance.getHostname(), metadata.get("traceInfo"));
            }
            for (String key : metadata.keySet()) {
                if (!key.startsWith("Exception")) continue;
                processingExceptions.add(new QueryProcessingException(Integer.parseInt(key.substring(9)), metadata.get(key)));
            }
            String numDocsScannedString = metadata.get("numDocsScanned");
            if (numDocsScannedString != null) {
                numDocsScanned += Long.parseLong(numDocsScannedString);
            }
            if ((numEntriesScannedInFilterString = metadata.get("numEntriesScannedInFilter")) != null) {
                numEntriesScannedInFilter += Long.parseLong(numEntriesScannedInFilterString);
            }
            if ((numEntriesScannedPostFilterString = metadata.get("numEntriesScannedPostFilter")) != null) {
                numEntriesScannedPostFilter += Long.parseLong(numEntriesScannedPostFilterString);
            }
            if ((numSegmentsQueriedString = metadata.get("numSegmentsQueried")) != null) {
                numSegmentsQueried += Long.parseLong(numSegmentsQueriedString);
            }
            if ((numSegmentsProcessedString = metadata.get("numSegmentsProcessed")) != null) {
                numSegmentsProcessed += Long.parseLong(numSegmentsProcessedString);
            }
            if ((numSegmentsMatchedString = metadata.get("numSegmentsMatched")) != null) {
                numSegmentsMatched += Long.parseLong(numSegmentsMatchedString);
            }
            if ((numTotalRawDocsString = metadata.get("totalDocs")) != null) {
                numTotalRawDocs += Long.parseLong(numTotalRawDocsString);
            }
            numGroupsLimitReached |= Boolean.valueOf(metadata.get("numGroupsLimitReached")).booleanValue();
            DataSchema dataSchema = dataTable.getDataSchema();
            if (dataSchema == null) {
                iterator.remove();
                continue;
            }
            if (dataTable.getNumberOfRows() == 0) {
                if (cachedDataSchema == null) {
                    cachedDataSchema = dataSchema;
                }
                iterator.remove();
                continue;
            }
            cachedDataSchema = dataSchema;
        }
        brokerResponseNative.setNumDocsScanned(numDocsScanned);
        brokerResponseNative.setNumEntriesScannedInFilter(numEntriesScannedInFilter);
        brokerResponseNative.setNumEntriesScannedPostFilter(numEntriesScannedPostFilter);
        brokerResponseNative.setNumSegmentsQueried(numSegmentsQueried);
        brokerResponseNative.setNumSegmentsProcessed(numSegmentsProcessed);
        brokerResponseNative.setNumSegmentsMatched(numSegmentsMatched);
        brokerResponseNative.setTotalDocs(numTotalRawDocs);
        brokerResponseNative.setNumGroupsLimitReached(numGroupsLimitReached);
        String tableName = brokerRequest.getQuerySource().getTableName();
        String rawTableName = TableNameBuilder.extractRawTableName(tableName);
        if (brokerMetrics != null) {
            brokerMetrics.addMeteredTableValue(rawTableName, BrokerMeter.DOCUMENTS_SCANNED, numDocsScanned);
            brokerMetrics.addMeteredTableValue(rawTableName, BrokerMeter.ENTRIES_SCANNED_IN_FILTER, numEntriesScannedInFilter);
            brokerMetrics.addMeteredTableValue(rawTableName, BrokerMeter.ENTRIES_SCANNED_POST_FILTER, numEntriesScannedPostFilter);
        }
        String preserveTypeString = brokerRequest.getQueryOptions() == null ? "false" : brokerRequest.getQueryOptions().getOrDefault("preserveType", "false");
        boolean preserveType = Boolean.valueOf(preserveTypeString);
        if (dataTableMap.isEmpty()) {
            if (cachedDataSchema != null) {
                List<String> selectionColumns = SelectionOperatorUtils.getSelectionColumns(brokerRequest.getSelections().getSelectionColumns(), cachedDataSchema);
                brokerResponseNative.setSelectionResults(new SelectionResults(selectionColumns, new ArrayList<Serializable[]>(0)));
            }
        } else {
            assert (cachedDataSchema != null);
            if (brokerRequest.isSetSelections()) {
                List<String> droppedServers;
                DataSchema masterDataSchema = cachedDataSchema.clone();
                if (dataTableMap.size() > 1 && !(droppedServers = this.removeConflictingResponses(masterDataSchema, dataTableMap)).isEmpty()) {
                    String errorMessage = QueryException.MERGE_RESPONSE_ERROR.getMessage() + ": responses for table: " + tableName + " from servers: " + droppedServers + " got dropped due to data schema inconsistency.";
                    LOGGER.info(errorMessage);
                    if (brokerMetrics != null) {
                        brokerMetrics.addMeteredTableValue(rawTableName, BrokerMeter.RESPONSE_MERGE_EXCEPTIONS, 1L);
                    }
                    brokerResponseNative.addToExceptions(new QueryProcessingException(500, errorMessage));
                }
                this.setSelectionResults(brokerResponseNative, brokerRequest.getSelections(), dataTableMap, masterDataSchema, preserveType);
            } else {
                AggregationFunction[] aggregationFunctions = AggregationFunctionUtils.getAggregationFunctions(brokerRequest.getAggregationsInfo());
                if (!brokerRequest.isSetGroupBy()) {
                    this.setAggregationResults(brokerResponseNative, aggregationFunctions, dataTableMap, cachedDataSchema, preserveType);
                } else {
                    boolean[] aggregationFunctionSelectStatus = AggregationFunctionUtils.getAggregationFunctionsSelectStatus(brokerRequest.getAggregationsInfo());
                    this.setGroupByHavingResults(brokerResponseNative, aggregationFunctions, aggregationFunctionSelectStatus, brokerRequest.getGroupBy(), dataTableMap, brokerRequest.getHavingFilterQuery(), brokerRequest.getHavingFilterSubQueryMap(), preserveType);
                    if (brokerMetrics != null && !brokerResponseNative.getAggregationResults().isEmpty()) {
                        brokerMetrics.addMeteredQueryValue(brokerRequest, BrokerMeter.GROUP_BY_SIZE, brokerResponseNative.getAggregationResults().get(0).getGroupByResult().size());
                    }
                }
            }
        }
        return brokerResponseNative;
    }

    @Nonnull
    private List<String> removeConflictingResponses(@Nonnull DataSchema dataSchema, @Nonnull Map<ServerInstance, DataTable> dataTableMap) {
        ArrayList<String> droppedServers = new ArrayList<String>();
        Iterator<Map.Entry<ServerInstance, DataTable>> iterator = dataTableMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ServerInstance, DataTable> entry = iterator.next();
            DataSchema dataSchemaToCompare = entry.getValue().getDataSchema();
            assert (dataSchemaToCompare != null);
            if (!dataSchema.isTypeCompatibleWith(dataSchemaToCompare)) {
                droppedServers.add(entry.getKey().toString());
                iterator.remove();
                continue;
            }
            dataSchema.upgradeToCover(dataSchemaToCompare);
        }
        return droppedServers;
    }

    private void setSelectionResults(@Nonnull BrokerResponseNative brokerResponseNative, @Nonnull Selection selection, @Nonnull Map<ServerInstance, DataTable> dataTableMap, @Nonnull DataSchema dataSchema, boolean preserveType) {
        int[] columnIndices;
        SelectionResults selectionResults;
        int selectionSize = selection.getSize();
        List<String> selectionColumns = SelectionOperatorUtils.getSelectionColumns(selection.getSelectionColumns(), dataSchema);
        if (selection.isSetSelectionSortSequence() && selectionSize != 0) {
            SelectionOperatorService selectionService = new SelectionOperatorService(selection, dataSchema);
            selectionService.reduceWithOrdering(dataTableMap);
            selectionResults = selectionService.renderSelectionResultsWithOrdering();
            columnIndices = SelectionOperatorUtils.getColumnIndicesWithOrdering(selectionColumns, dataSchema);
        } else {
            selectionResults = SelectionOperatorUtils.renderSelectionResultsWithoutOrdering(SelectionOperatorUtils.reduceWithoutOrdering(dataTableMap, selectionSize), dataSchema, selectionColumns);
            columnIndices = SelectionOperatorUtils.getColumnIndicesWithoutOrdering(selectionColumns, dataSchema);
        }
        if (!preserveType) {
            selectionResults.setRows(SelectionOperatorUtils.formatRowsWithOrdering(selectionResults.getRows(), columnIndices, dataSchema));
        }
        brokerResponseNative.setSelectionResults(selectionResults);
    }

    private void setAggregationResults(@Nonnull BrokerResponseNative brokerResponseNative, @Nonnull AggregationFunction[] aggregationFunctions, @Nonnull Map<ServerInstance, DataTable> dataTableMap, @Nonnull DataSchema dataSchema, boolean preserveType) {
        int numAggregationFunctions = aggregationFunctions.length;
        Object[] intermediateResults = new Object[numAggregationFunctions];
        for (DataTable dataTable : dataTableMap.values()) {
            for (int i = 0; i < numAggregationFunctions; ++i) {
                Object intermediateResultToMerge;
                DataSchema.ColumnDataType columnDataType = dataSchema.getColumnDataType(i);
                switch (columnDataType) {
                    case LONG: {
                        intermediateResultToMerge = dataTable.getLong(0, i);
                        break;
                    }
                    case DOUBLE: {
                        intermediateResultToMerge = dataTable.getDouble(0, i);
                        break;
                    }
                    case OBJECT: {
                        intermediateResultToMerge = dataTable.getObject(0, i);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Illegal column data type in aggregation results: " + (Object)((Object)columnDataType));
                    }
                }
                Object mergedIntermediateResult = intermediateResults[i];
                intermediateResults[i] = mergedIntermediateResult == null ? intermediateResultToMerge : aggregationFunctions[i].merge(mergedIntermediateResult, intermediateResultToMerge);
            }
        }
        ArrayList<AggregationResult> reducedAggregationResults = new ArrayList<AggregationResult>(numAggregationFunctions);
        for (int i = 0; i < numAggregationFunctions; ++i) {
            Object resultValue = AggregationFunctionUtils.getSerializableValue(aggregationFunctions[i].extractFinalResult(intermediateResults[i]));
            if (!preserveType) {
                resultValue = AggregationFunctionUtils.formatValue(resultValue);
            }
            reducedAggregationResults.add(new AggregationResult(dataSchema.getColumnName(i), (Serializable)resultValue));
        }
        brokerResponseNative.setAggregationResults(reducedAggregationResults);
    }

    private void setGroupByHavingResults(@Nonnull BrokerResponseNative brokerResponseNative, @Nonnull AggregationFunction[] aggregationFunctions, boolean[] aggregationFunctionsSelectStatus, @Nonnull GroupBy groupBy, @Nonnull Map<ServerInstance, DataTable> dataTableMap, HavingFilterQuery havingFilterQuery, HavingFilterQueryMap havingFilterQueryMap, boolean preserveType) {
        ArrayList<AggregationResult> arrayList;
        int numAggregationFunctions = aggregationFunctions.length;
        String[] columnNames = new String[numAggregationFunctions];
        Map[] intermediateResultMaps = new Map[numAggregationFunctions];
        for (DataTable dataTable : dataTableMap.values()) {
            for (int i = 0; i < numAggregationFunctions; ++i) {
                if (columnNames[i] == null) {
                    columnNames[i] = dataTable.getString(i, 0);
                    intermediateResultMaps[i] = (Map)dataTable.getObject(i, 1);
                    continue;
                }
                Map mergedIntermediateResultMap = intermediateResultMaps[i];
                Map intermediateResultMapToMerge = (Map)dataTable.getObject(i, 1);
                for (Map.Entry entry : intermediateResultMapToMerge.entrySet()) {
                    String groupKey = (String)entry.getKey();
                    Object v = entry.getValue();
                    if (mergedIntermediateResultMap.containsKey(groupKey)) {
                        Object mergedIntermediateResult = mergedIntermediateResultMap.get(groupKey);
                        mergedIntermediateResultMap.put(groupKey, aggregationFunctions[i].merge(mergedIntermediateResult, v));
                        continue;
                    }
                    mergedIntermediateResultMap.put(groupKey, v);
                }
            }
        }
        Map[] finalResultMaps = new Map[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            Map intermediateResultMap = intermediateResultMaps[i];
            HashMap finalResultMap = new HashMap();
            for (String groupKey : intermediateResultMap.keySet()) {
                Object intermediateResult = intermediateResultMap.get(groupKey);
                finalResultMap.put(groupKey, aggregationFunctions[i].extractFinalResult(intermediateResult));
            }
            finalResultMaps[i] = finalResultMap;
        }
        if (havingFilterQuery != null) {
            HavingClauseComparisonTree havingClauseComparisonTree = HavingClauseComparisonTree.buildHavingClauseComparisonTree(havingFilterQuery, havingFilterQueryMap);
            Set intersectionOfKeySets = finalResultMaps[0].keySet();
            for (int i = 1; i < numAggregationFunctions; ++i) {
                intersectionOfKeySets.retainAll(finalResultMaps[i].keySet());
            }
            TreeMap<String, Comparable> singleGroupAggResults = new TreeMap<String, Comparable>(String.CASE_INSENSITIVE_ORDER);
            Map[] finalFilteredResultMaps = new Map[numAggregationFunctions];
            for (int i = 0; i < numAggregationFunctions; ++i) {
                finalFilteredResultMaps[i] = new HashMap();
            }
            for (String groupKey : intersectionOfKeySets) {
                int i;
                for (i = 0; i < numAggregationFunctions; ++i) {
                    singleGroupAggResults.put(columnNames[i], (Comparable)finalResultMaps[i].get(groupKey));
                }
                if (!havingClauseComparisonTree.isThisGroupPassPredicates(singleGroupAggResults)) continue;
                for (i = 0; i < numAggregationFunctions; ++i) {
                    finalFilteredResultMaps[i].put(groupKey, singleGroupAggResults.get(columnNames[i]));
                }
            }
            finalResultMaps = finalFilteredResultMaps;
        }
        int aggregationNumsInFinalResult = 0;
        for (int i = 0; i < numAggregationFunctions; ++i) {
            if (!aggregationFunctionsSelectStatus[i]) continue;
            ++aggregationNumsInFinalResult;
        }
        if (aggregationNumsInFinalResult > 0) {
            String[] finalColumnNames = new String[aggregationNumsInFinalResult];
            Map[] finalOutResultMaps = new Map[aggregationNumsInFinalResult];
            AggregationFunction[] finalAggregationFunctions = new AggregationFunction[aggregationNumsInFinalResult];
            int count = 0;
            for (int i = 0; i < numAggregationFunctions; ++i) {
                if (!aggregationFunctionsSelectStatus[i]) continue;
                finalColumnNames[count] = columnNames[i];
                finalOutResultMaps[count] = finalResultMaps[i];
                finalAggregationFunctions[count] = aggregationFunctions[i];
                ++count;
            }
            AggregationGroupByTrimmingService aggregationGroupByTrimmingService = new AggregationGroupByTrimmingService(finalAggregationFunctions, (int)groupBy.getTopN());
            List<GroupByResult>[] groupByResultLists = aggregationGroupByTrimmingService.trimFinalResults(finalOutResultMaps);
            if (!preserveType) {
                for (List<GroupByResult> list : groupByResultLists) {
                    for (GroupByResult groupByResult : list) {
                        groupByResult.setValue((Serializable)((Object)AggregationFunctionUtils.formatValue(groupByResult.getValue())));
                    }
                }
            }
            arrayList = new ArrayList<AggregationResult>(count);
            for (int i = 0; i < aggregationNumsInFinalResult; ++i) {
                List<GroupByResult> groupByResultList = groupByResultLists[i];
                arrayList.add(new AggregationResult(groupByResultList, groupBy.getExpressions(), finalColumnNames[i]));
            }
        } else {
            throw new IllegalStateException("There should be minimum one aggregation function in the select list of a Group by query");
        }
        brokerResponseNative.setAggregationResults(arrayList);
    }
}

