/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.reduce;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.Selection;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombineService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CombineService.class);

    private CombineService() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void mergeTwoBlocks(@Nonnull BrokerRequest brokerRequest, @Nonnull IntermediateResultsBlock mergedBlock, @Nonnull IntermediateResultsBlock blockToMerge) {
        List<ProcessingException> mergedProcessingExceptions = mergedBlock.getProcessingExceptions();
        List<ProcessingException> processingExceptionsToMerge = blockToMerge.getProcessingExceptions();
        if (mergedProcessingExceptions == null) {
            mergedBlock.setProcessingExceptions(processingExceptionsToMerge);
        } else if (processingExceptionsToMerge != null) {
            mergedProcessingExceptions.addAll(processingExceptionsToMerge);
        }
        if (brokerRequest.isSetAggregationsInfo()) {
            if (brokerRequest.isSetGroupBy()) throw new UnsupportedOperationException();
            List<Object> aggregationResultToMerge = blockToMerge.getAggregationResult();
            if (aggregationResultToMerge == null) {
                return;
            }
            AggregationFunctionContext[] mergedAggregationFunctionContexts = mergedBlock.getAggregationFunctionContexts();
            if (mergedAggregationFunctionContexts == null) {
                mergedBlock.setAggregationFunctionContexts(blockToMerge.getAggregationFunctionContexts());
                mergedBlock.setAggregationResults(aggregationResultToMerge);
            }
            List<Object> mergedAggregationResult = mergedBlock.getAggregationResult();
            int numAggregationFunctions = mergedAggregationFunctionContexts.length;
            for (int i = 0; i < numAggregationFunctions; ++i) {
                mergedAggregationResult.set(i, mergedAggregationFunctionContexts[i].getAggregationFunction().merge(mergedAggregationResult.get(i), aggregationResultToMerge.get(i)));
            }
            return;
        } else {
            DataSchema mergedBlockSchema = mergedBlock.getSelectionDataSchema();
            DataSchema blockToMergeSchema = blockToMerge.getSelectionDataSchema();
            Collection<Serializable[]> mergedBlockResultSet = mergedBlock.getSelectionResult();
            Collection<Serializable[]> blockToMergeResultSet = blockToMerge.getSelectionResult();
            if (mergedBlockSchema == null || mergedBlockResultSet.size() == 0) {
                if (blockToMergeSchema == null) return;
                mergedBlock.setSelectionDataSchema(blockToMergeSchema);
                mergedBlock.setSelectionResult(blockToMergeResultSet);
                return;
            } else {
                Selection selection = brokerRequest.getSelections();
                boolean isSelectionOrderBy = selection.isSetSelectionSortSequence();
                int selectionSize = selection.getSize();
                if (!isSelectionOrderBy && mergedBlockResultSet.size() == selectionSize) {
                    return;
                }
                if (blockToMergeSchema == null || blockToMergeResultSet.size() <= 0) return;
                if (mergedBlockSchema.isTypeCompatibleWith(blockToMergeSchema)) {
                    mergedBlockSchema.upgradeToCover(blockToMergeSchema);
                    if (isSelectionOrderBy) {
                        SelectionOperatorUtils.mergeWithOrdering((PriorityQueue)mergedBlockResultSet, blockToMergeResultSet, selection.getOffset() + selectionSize);
                    } else {
                        SelectionOperatorUtils.mergeWithoutOrdering(mergedBlockResultSet, blockToMergeResultSet, selectionSize);
                    }
                    mergedBlock.setSelectionResult(mergedBlockResultSet);
                    return;
                } else {
                    String errorMessage = "Data schema inconsistency between merged block schema: " + mergedBlockSchema + " and block to merge schema: " + blockToMergeSchema + ", drop block to merge";
                    LOGGER.info(errorMessage);
                    mergedBlock.addToProcessingExceptions(QueryException.getException(QueryException.MERGE_RESPONSE_ERROR, errorMessage));
                }
            }
        }
    }
}

