/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.request;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.query.request.context.TimerContext;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.GroupBy;
import org.apache.pinot.common.request.InstanceRequest;
import org.apache.pinot.common.request.Selection;
import org.apache.pinot.common.request.transform.TransformExpressionTree;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;

public class ServerQueryRequest {
    private final long _requestId;
    private final BrokerRequest _brokerRequest;
    private final String _tableNameWithType;
    private final List<String> _segmentsToQuery;
    private final boolean _enableTrace;
    private final String _brokerId;
    private final TimerContext _timerContext;
    private final Set<String> _allColumns;
    private final FilterQueryTree _filterQueryTree;
    private final Set<String> _filterColumns;
    private final Set<TransformExpressionTree> _aggregationExpressions;
    private final Set<String> _aggregationColumns;
    private final Set<TransformExpressionTree> _groupByExpressions;
    private final Set<String> _groupByColumns;
    private final Set<String> _selectionColumns;
    private volatile int _segmentCountAfterPruning = -1;

    public ServerQueryRequest(InstanceRequest instanceRequest, ServerMetrics serverMetrics, long queryArrivalTimeMs) {
        this._requestId = instanceRequest.getRequestId();
        this._brokerRequest = instanceRequest.getQuery();
        this._tableNameWithType = this._brokerRequest.getQuerySource().getTableName();
        this._segmentsToQuery = instanceRequest.getSearchSegments();
        this._enableTrace = instanceRequest.isEnableTrace();
        this._brokerId = instanceRequest.getBrokerId() != null ? instanceRequest.getBrokerId() : "unknown";
        this._timerContext = new TimerContext(this._tableNameWithType, serverMetrics, queryArrivalTimeMs);
        this._allColumns = new HashSet<String>();
        this._filterQueryTree = RequestUtils.generateFilterQueryTree(this._brokerRequest);
        if (this._filterQueryTree != null) {
            this._filterColumns = RequestUtils.extractFilterColumns(this._filterQueryTree);
            this._allColumns.addAll(this._filterColumns);
        } else {
            this._filterColumns = null;
        }
        List<AggregationInfo> aggregationsInfo = this._brokerRequest.getAggregationsInfo();
        if (aggregationsInfo != null) {
            this._aggregationExpressions = new HashSet<TransformExpressionTree>();
            for (AggregationInfo aggregationInfo : aggregationsInfo) {
                if (aggregationInfo.getAggregationType().equalsIgnoreCase(AggregationFunctionType.COUNT.getName())) continue;
                this._aggregationExpressions.add(TransformExpressionTree.compileToExpressionTree(AggregationFunctionUtils.getColumn(aggregationInfo)));
            }
            this._aggregationColumns = RequestUtils.extractColumnsFromExpressions(this._aggregationExpressions);
            this._allColumns.addAll(this._aggregationColumns);
        } else {
            this._aggregationExpressions = null;
            this._aggregationColumns = null;
        }
        GroupBy groupBy = this._brokerRequest.getGroupBy();
        if (groupBy != null) {
            this._groupByExpressions = new HashSet<TransformExpressionTree>();
            for (String expression : groupBy.getExpressions()) {
                this._groupByExpressions.add(TransformExpressionTree.compileToExpressionTree(expression));
            }
            this._groupByColumns = RequestUtils.extractColumnsFromExpressions(this._groupByExpressions);
            this._allColumns.addAll(this._groupByColumns);
        } else {
            this._groupByExpressions = null;
            this._groupByColumns = null;
        }
        Selection selection = this._brokerRequest.getSelections();
        if (selection != null) {
            this._selectionColumns = RequestUtils.extractSelectionColumns(selection);
            this._allColumns.addAll(this._selectionColumns);
        } else {
            this._selectionColumns = null;
        }
    }

    public long getRequestId() {
        return this._requestId;
    }

    public BrokerRequest getBrokerRequest() {
        return this._brokerRequest;
    }

    public String getTableNameWithType() {
        return this._tableNameWithType;
    }

    public List<String> getSegmentsToQuery() {
        return this._segmentsToQuery;
    }

    public boolean isEnableTrace() {
        return this._enableTrace;
    }

    public String getBrokerId() {
        return this._brokerId;
    }

    public TimerContext getTimerContext() {
        return this._timerContext;
    }

    public Set<String> getAllColumns() {
        return this._allColumns;
    }

    @Nullable
    public FilterQueryTree getFilterQueryTree() {
        return this._filterQueryTree;
    }

    @Nullable
    public Set<String> getFilterColumns() {
        return this._filterColumns;
    }

    @Nullable
    public Set<TransformExpressionTree> getAggregationExpressions() {
        return this._aggregationExpressions;
    }

    @Nullable
    public Set<String> getAggregationColumns() {
        return this._aggregationColumns;
    }

    @Nullable
    public Set<TransformExpressionTree> getGroupByExpressions() {
        return this._groupByExpressions;
    }

    @Nullable
    public Set<String> getGroupByColumns() {
        return this._groupByColumns;
    }

    @Nullable
    public Set<String> getSelectionColumns() {
        return this._selectionColumns;
    }
}

