/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.request.context;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.metrics.ServerQueryPhase;

public class TimerContext {
    private final String _tableNameWithType;
    private final ServerMetrics _serverMetrics;
    private final long _queryArrivalTimeMs;
    private final Timer[] _phaseTimers = new Timer[ServerQueryPhase.values().length];

    public TimerContext(String tableNameWithType, ServerMetrics serverMetrics, long queryArrivalTimeMs) {
        this._tableNameWithType = tableNameWithType;
        this._serverMetrics = serverMetrics;
        this._queryArrivalTimeMs = queryArrivalTimeMs;
    }

    public long getQueryArrivalTimeMs() {
        return this._queryArrivalTimeMs;
    }

    public Timer startNewPhaseTimer(ServerQueryPhase queryPhase, long startTimeMs) {
        Timer phaseTimer;
        this._phaseTimers[queryPhase.ordinal()] = phaseTimer = new Timer(queryPhase, startTimeMs);
        return phaseTimer;
    }

    public Timer startNewPhaseTimer(ServerQueryPhase queryPhase) {
        return this.startNewPhaseTimer(queryPhase, System.currentTimeMillis());
    }

    @Nullable
    public Timer getPhaseTimer(ServerQueryPhase queryPhase) {
        return this._phaseTimers[queryPhase.ordinal()];
    }

    public long getPhaseDurationMs(ServerQueryPhase queryPhase) {
        Timer phaseTimer = this._phaseTimers[queryPhase.ordinal()];
        return phaseTimer != null ? phaseTimer.getDurationMs() : -1L;
    }

    public class Timer {
        private final ServerQueryPhase _queryPhase;
        private final long _startTimeMs;
        private volatile long _durationMs;
        private volatile boolean _ended;

        private Timer(ServerQueryPhase queryPhase, long startTimeMs) {
            this._queryPhase = queryPhase;
            this._startTimeMs = startTimeMs;
        }

        public void stopAndRecord() {
            if (!this._ended) {
                this._durationMs = System.currentTimeMillis() - this._startTimeMs;
                TimerContext.this._serverMetrics.addPhaseTiming(TimerContext.this._tableNameWithType, this._queryPhase, this._durationMs, TimeUnit.MILLISECONDS);
                this._ended = true;
            }
        }

        public long getDurationMs() {
            return this._ended ? this._durationMs : -1L;
        }
    }
}

