/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerGroup;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerQueryContext;

public abstract class AbstractSchedulerGroup
implements SchedulerGroup {
    protected final ConcurrentLinkedQueue<SchedulerQueryContext> pendingQueries = new ConcurrentLinkedQueue();
    protected final String name;
    protected AtomicInteger numRunning = new AtomicInteger(0);
    protected AtomicInteger threadsInUse = new AtomicInteger(0);
    protected AtomicInteger reservedThreads = new AtomicInteger(0);

    public AbstractSchedulerGroup(@Nonnull String name) {
        Preconditions.checkNotNull(name);
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void addLast(SchedulerQueryContext query) {
        this.pendingQueries.add(query);
    }

    @Override
    public SchedulerQueryContext peekFirst() {
        return this.pendingQueries.peek();
    }

    @Override
    public SchedulerQueryContext removeFirst() {
        return this.pendingQueries.poll();
    }

    @Override
    public void trimExpired(long deadlineMillis) {
        Iterator<SchedulerQueryContext> iter = this.pendingQueries.iterator();
        while (iter.hasNext()) {
            SchedulerQueryContext next = iter.next();
            if (next.getArrivalTimeMs() >= deadlineMillis) continue;
            iter.remove();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.pendingQueries.isEmpty();
    }

    @Override
    public int numPending() {
        return this.pendingQueries.size();
    }

    @Override
    public int numRunning() {
        return this.numRunning.get();
    }

    @Override
    public void incrementThreads() {
        this.threadsInUse.incrementAndGet();
    }

    @Override
    public void decrementThreads() {
        this.threadsInUse.decrementAndGet();
    }

    @Override
    public int getThreadsInUse() {
        return this.threadsInUse.get();
    }

    @Override
    public void addReservedThreads(int threads) {
        this.reservedThreads.addAndGet(threads);
    }

    @Override
    public void releasedReservedThreads(int threads) {
        this.reservedThreads.addAndGet(-1 * threads);
    }

    @Override
    public int totalReservedThreads() {
        return this.reservedThreads.get();
    }

    @Override
    public void startQuery() {
        this.incrementThreads();
        this.numRunning.incrementAndGet();
    }

    @Override
    public void endQuery() {
        this.decrementThreads();
        this.numRunning.decrementAndGet();
    }
}

